package com.digiwin.athena.base.presentation.server.web.appexpire;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.service.appexpire.AppExpireService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * AppExpireController Description
 *
 * @author majianfu
 * @date 2022/11/3
 * @since
 */
@RestController
@RequestMapping(value = "/api/audc/v1/app-expire")
public class AppExpireController {
    @Autowired
    private AppExpireService appExpireService;

    /**
     * 校验作业所属应用是否过期
     *
     * @param activityId
     * @param projectId  (可选，目前没用到)
     * @return
     */
    @GetMapping("/check/activity")
    public ResponseEntity<?> checkAppExpireForActivity(@RequestParam(value = "projectId", required = false) String projectId, @RequestParam("activityId") String activityId) {
        appExpireService.checkActivityAppExpired(projectId, activityId);
        return ResponseEntityWrapper.wrapperOk();
    }
}
