package com.digiwin.athena.base.presentation.server.web.trial;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.trial.step.TrialStepReq;
import com.digiwin.athena.base.application.service.trial.TrialStepService;
import com.digiwin.athena.base.infrastructure.meta.po.trial.TrialStepData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 描述
 * 演示的应用步骤进行维护
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/03 15:21:30
 */
@Slf4j
@RestController
@RequestMapping(value = "")
public class TrialStepController {

    private final TrialStepService trialStepService;

    /**
     * 构造函数注入对象
     *
     * @param trialStepService trialStepService
     */
    public TrialStepController(TrialStepService trialStepService) {
        this.trialStepService = trialStepService;
    }

    /**
     * 新增步骤
     *
     * @return ResponseEntity
     */
    @PostMapping(value = "/add", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> add(@RequestBody TrialStepReq req) {
        Long result = trialStepService.add(req);
        return ResponseEntityWrapper.wrapperOk(result);
    }

    /**
     * 修改步骤
     *
     * @return ResponseEntity
     */
    @PostMapping(value = "/modify", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> modify(@RequestBody TrialStepReq req) {
        int result = trialStepService.modify(req);
        return ResponseEntityWrapper.wrapperOk(result);
    }

    /**
     * 删除步骤
     *
     * @return ResponseEntity
     */
    @GetMapping(value = "/delete/{id}", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> deleteById(@PathVariable("id") long id) {

        int result = trialStepService.deleteById(id);
        return ResponseEntityWrapper.wrapperOk(result);
    }

    /**
     * 查询步骤列表
     *
     * @return ResponseEntity
     */
    @GetMapping(value = "/queryByStepKey", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> queryByStepKey(@RequestParam(value = "stepKey", required = false) String stepKey) {
        TrialStepReq req = new TrialStepReq();
        req.setStepKey(stepKey);
        List<TrialStepData> result = trialStepService.list(req);
        return ResponseEntityWrapper.wrapperOk(result);
    }
}
