package com.digiwin.athena.base.presentation.server.web.userdefined;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.userdefined.AgileReportUserDefineDTO;
import com.digiwin.athena.base.application.service.userdefined.AgileReportUserDefineService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@RestController
@RequestMapping(value = "/api/ai/userDefined")
public class AgileReportUserDefineController {

    @Autowired
    AgileReportUserDefineService agileReportUserDefineService;
    /**
     * 根据当前用户操作，保存页面表格布局
     * @return
     */
    @PostMapping("/save")
    ResponseEntity<?> saveFieldActions(@RequestBody Map filedJson,
                                       @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        AgileReportUserDefineDTO userDefineDTO =  JsonUtils.jsonToObject(JsonUtils.objectToString(filedJson), AgileReportUserDefineDTO.class);
        agileReportUserDefineService.save(user.getUserId(), user.getTenantId(), userDefineDTO);

        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 根据snapshotId获取数据库中用户布局
     * @return
     */
    @GetMapping("/getField/{snapshotId}")
    ResponseEntity<?> getFieldActions(@PathVariable("snapshotId") String snapshotId,
                                      @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){

        return ResponseEntityWrapper.wrapperOk(agileReportUserDefineService.getUserDefine(snapshotId, user.getUserId(),user.getTenantId()));
    }
}
