/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.trial;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.trial.scene.TrialSceneReq;
import com.digiwin.athena.base.application.meta.request.trial.scene.TrialSceneResp;
import com.digiwin.athena.base.application.meta.request.trial.sceneStep.TrialSceneStepBindReq;
import com.digiwin.athena.base.application.service.trial.TrialSceneService;
import com.digiwin.athena.base.application.service.trial.TrialUserSceneService;
import com.digiwin.athena.base.infrastructure.meta.po.trial.TrialSceneData;
import java.util.List;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/trial/scene"})
public class TrialSceneController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrialSceneController.class);
    private final TrialSceneService trialSceneService;
    private final TrialUserSceneService trialUserSceneService;

    public TrialSceneController(TrialSceneService trialSceneService, TrialUserSceneService trialUserSceneService) {
        this.trialSceneService = trialSceneService;
        this.trialUserSceneService = trialUserSceneService;
    }

    @PostMapping(value={"/add"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> add(@RequestBody TrialSceneReq req) {
        Long result = this.trialSceneService.add(req);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @PostMapping(value={"/modify"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> modify(@RequestBody TrialSceneReq req) {
        int result = this.trialSceneService.modify(req);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/delete/{id}"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> deleteById(@PathVariable(value="id") long id) {
        int result = this.trialSceneService.deleteById(Long.valueOf(id));
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/queryBySceneKey"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> queryBySceneKey(@RequestParam(value="sceneKey", required=false) String sceneKey) {
        TrialSceneReq req = new TrialSceneReq();
        req.setSceneKey(sceneKey);
        List respList = this.trialSceneService.list(req);
        return ResponseEntityWrapper.wrapperOk((Object)respList);
    }

    @PostMapping(value={"/bindSteps"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> bindSteps(@RequestBody TrialSceneStepBindReq req) {
        this.trialSceneService.bindSteps(req);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/queryWithSteps"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> queryWithSteps(@RequestParam(value="sceneKey", required=false) String sceneKey) {
        TrialSceneReq req = new TrialSceneReq();
        req.setSceneKey(sceneKey);
        TrialSceneResp result = this.trialSceneService.listWithSteps(req);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/detail/{sceneKey}"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> detail(@PathVariable(value="sceneKey") String sceneKey) {
        TrialSceneData data = this.trialSceneService.sceneDetail(sceneKey);
        return ResponseEntityWrapper.wrapperOk((Object)JsonUtils.jsonToObject((String)data.getDetail(), JSONObject.class));
    }

    @GetMapping(value={"/delete/user/{id}"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> deleteSceneById(@PathVariable(value="id") long id) {
        this.trialUserSceneService.deleteBindSceneBySceneId(Long.valueOf(id));
        int result = this.trialSceneService.deleteById(Long.valueOf(id));
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }
}

