package com.digiwin.athena.base.presentation.server.web.watermark;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.sdk.audc.application.service.watermark.QueryWatermarkConfigService;
import com.digiwin.athena.tdd.sdk.meta.dto.request.WaterMarkConfigReqDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author mk
 * @date 2024/10/31 18:03
 * @description:水印相关接口
 */
@RestController
@RequestMapping(value = "/watermark")
public class WatermarkController {
    @Autowired
    private QueryWatermarkConfigService queryWatermarkConfigService;

    /**
     * 获取水印配置
     *
     * @param waterMarkConfigReqDTO
     * @return
     */
    @PostMapping("/getWatermarkConfig")
    public ResponseEntity<?> getTenantConfig(@RequestBody WaterMarkConfigReqDTO waterMarkConfigReqDTO) {
        return ResponseEntityWrapper.wrapperOk(queryWatermarkConfigService.getWaterMarkConfig(waterMarkConfigReqDTO));
    }
}
