/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.cofw;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.service.cofw.CofwService;
import com.digiwin.athena.base.infrastructure.meta.po.cofw.Cofw;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/audc/v1/cofw"})
public class CofwActionController {
    private static final Logger logger = LoggerFactory.getLogger(CofwActionController.class);
    public static final int DEL_FLAG_0 = 0;
    public static final int DEL_FLAG_1 = 1;
    @Autowired
    private CofwService cofwService;

    @GetMapping(value={"/list"})
    ResponseEntity<?> getCofwListActions(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        List list = this.cofwService.getCofwList(user);
        return ResponseEntityWrapper.wrapperOk((Object)list);
    }

    @PostMapping(value={"/save"})
    ResponseEntity<?> saveCofwActions(@RequestBody JSONObject cofwbody, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.cofwService.save(user, cofwbody);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/getOneCofwById/{id}"})
    ResponseEntity<?> getOneCofwByIdActions(@PathVariable long id, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Cofw cofw = this.cofwService.getOneCofwById(id);
        return ResponseEntityWrapper.wrapperOk((Object)cofw);
    }

    @PostMapping(value={"/updateById"})
    ResponseEntity<?> updateCofwByIdActions(@RequestBody JSONObject cofwreq, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        if (cofwreq != null) {
            long id = cofwreq.getLong("id");
            String cofwname = cofwreq.getString("cofwName");
            Cofw cofw = this.cofwService.getOneCofwById(id);
            if (cofw != null) {
                cofw.setCofwName(cofwname);
                cofw.setModifyTime(LocalDateTime.now());
                cofw.setModifyUserId(user.getUserId());
                this.cofwService.updateCofwById(cofw);
            }
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/deleteById/{id}"})
    ResponseEntity<?> deleteCofwByIdActions(@PathVariable long id, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Cofw cofw = this.cofwService.getOneCofwById(id);
        if (cofw != null) {
            cofw.setDelFlag(1);
            cofw.setDelUserId(user.getUserId());
            cofw.setDelTime(LocalDateTime.now());
            this.cofwService.updateCofwById(cofw);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/deleteByTenant/{tenantId}"})
    ResponseEntity<?> deleteByTenant(@PathVariable String tenantId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        logger.info("UserId:[" + user.getUserId() + "] Name:[" + user.getUserName() + "] Ready to Delete snapshot info");
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        int result = this.cofwService.deleteByTenant(tenantId);
        if (result >= 0) {
            retMap.put("retCode", "0");
            retMap.put("retDesc", "delete success");
            retMap.put("effectNum", result);
        } else {
            retMap.put("retCode", "-1");
            retMap.put("retDesc", "delete fail");
            retMap.put("effectNum", 0);
        }
        logger.info("UserId:[" + user.getUserId() + "] Name:[" + user.getUserName() + "]  Delete snapshot info with retCode:[" + MapUtils.getString(retMap, (Object)"code") + "]");
        return ResponseEntityWrapper.wrapperOk(retMap);
    }
}

