package com.digiwin.athena.base.presentation.server.web.guide;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.guide.UserGuidePoJo;
import com.digiwin.athena.base.application.meta.response.guide.UserGuideResult;
import com.digiwin.athena.base.application.service.guide.UserGuideService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2022/05/18 13:54:44
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/guide")
public class UserGuideController {
    /**
     * 禁用状态
     */
    private static final int GUIDE_STATE_DISABLE = 1;

    private final UserGuideService userGuideService;

    /**
     * default construct
     *
     * @param userGuideService 业务处理方法
     */
    @Autowired
    public UserGuideController(UserGuideService userGuideService)
    {
        this.userGuideService = userGuideService;
    }

    /**
     * 唤起用户新手引导功能
     *
     * @param user        用户信息
     * @param modularCode 模块code 按照全部菜单分级调整，基础资料:baseEntrty 报表：report  发起项目：startProject
     * @param code        code，与KM定义的要一致
     * @param appCode     应用code，例如PCC，FRC等
     * @return ResponseEntity
     */
    @GetMapping(value = {"/call","/open/call"}, produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> call(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user,
                                  @RequestParam(value = "modularCode") String modularCode,
                                  @RequestParam(value = "code") String code,
                                  @RequestParam(value = "appCode") String appCode,
                                  @RequestParam(value = "subKey") String subKey) {


        //封装调用的pojo信息
        UserGuidePoJo pojo = packagePojo(user, modularCode, code, appCode, null, subKey);
        //判断当前请求的内容，对应的引导信息
        UserGuideResult result = new UserGuideResult();
        try {
            result = userGuideService.queryGuideInfo(pojo);
        } catch (BusinessException e) {
            result.setRetCode(e.getCode());
            result.setRetDesc(e.getMessage());
        }
        return ResponseEntityWrapper.wrapperOk(result);

    }

    /**
     * 人工设置引导状态
     *
     * @param user        用户信息
     * @param modularCode 模块code 按照全部菜单分级调整，基础资料:baseEntrty 报表：report  发起项目：startProject
     * @param code        code，与KM定义的要一致
     * @param appCode     应用code
     * @return ResponseEntity
     */
    @GetMapping(value = "/disable", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> disableGuideInfo(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user,
                                              @RequestParam(value = "modularCode") String modularCode,
                                              @RequestParam(value = "code") String code,
                                              @RequestParam(value = "appCode") String appCode,
                                              @RequestParam(value = "subKey") String subKey) {


        UserGuideResult retInfo = new UserGuideResult();
        //封装调用的pojo信息
        UserGuidePoJo pojo = packagePojo(user, modularCode, code, appCode, GUIDE_STATE_DISABLE, subKey);
        //判断当前请求的内容，对应的引导信息
        try {
            retInfo = userGuideService.disableGuideInfo(pojo);
        } catch (BusinessException e) {
            retInfo.setRetCode(e.getCode());
            retInfo.setRetDesc(e.getMessage());
        }


        return ResponseEntityWrapper.wrapperOk(retInfo);
    }


    /**
     * 给指定用户重置引导
     *
     * @param user 用户信息
     * @return ResponseEntity
     */
    @GetMapping(value = "/reset", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> disableGuideInfo(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {


        UserGuideResult retInfo = new UserGuideResult();
        //判断当前请求的内容，对应的引导信息
        try {
            retInfo = userGuideService.resetUserGuideInfo(user.getUserId());
        } catch (BusinessException e) {
            retInfo.setRetCode(e.getCode());
            retInfo.setRetDesc(e.getMessage());
        }


        return ResponseEntityWrapper.wrapperOk(retInfo);
    }


    /**
     * 封装处理参数
     *
     * @param user        用户信息
     * @param modularCode 模块code 按照全部菜单分级调整，基础资料:baseEntrty 报表：report  发起项目：startProject
     * @param code        作业code
     * @param appCode     应用编码code
     * @param state       引导状态，0:  启用 1：停用 ，默认启用：0
     * @return pojo
     */
    private UserGuidePoJo packagePojo(AuthoredUser user, String modularCode, String code, String appCode, Integer state, String subKey) {
        UserGuidePoJo pojo = new UserGuidePoJo();
        pojo.setUserId(user.getUserId());
        pojo.setTenantId(user.getTenantId());
        pojo.setModularCode(modularCode);
        pojo.setCode(code);
        pojo.setAppCode(appCode);
        pojo.setState(state);
        pojo.setSubKey(subKey);
        return pojo;
    }
}
