package com.digiwin.athena.base.presentation.server.web.permission;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.permission.TypeActivities;
import com.digiwin.athena.base.application.meta.request.permission.TypeActivitiesAccessible;
import com.digiwin.athena.base.application.meta.response.permission.ActivityAccessible;
import com.digiwin.athena.base.application.service.permission.PermissionCheckService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * PermissionController Description
 * 权限校验接口
 *
 * @author majianfu
 * @date 2021/10/9
 * @since
 */
@RestController
@RequestMapping(value = "/api/audc")
public class PermissionCheckController {
    @Resource
    private PermissionCheckService permissionCheckService;

    /**
     * 批量校验作业的访问权限
     *
     * @param tmActivityIdList
     * @return
     */
    @GetMapping("/v1/permission/activity/checkAccess")
    @Deprecated
    ResponseEntity<?> checkActivityAccessible(@RequestParam("tmActivityId") @NotNull List<String> tmActivityIdList) {
        AuthoredUser authoredUser = getAuthoredUser();

        List<ActivityAccessible> permissionCheckResultList = permissionCheckService.checkActivityAccessible(authoredUser, tmActivityIdList);
        return ResponseEntityWrapper.wrapperOk(permissionCheckResultList);
    }

    /**
     * 批量校验不同类型作业的访问权限
     *
     * @param typeActivitiesList 每个类型作业id列表
     * @return
     */
    @PostMapping("/v1/check/activity/accessible")
    ResponseEntity<?> checkTypeActivitiesAccessible(@RequestBody List<TypeActivities> typeActivitiesList) {
        AuthoredUser authoredUser = getAuthoredUser();

        List<TypeActivitiesAccessible> permissionCheckResultList = permissionCheckService.checkTypeActivitiesAccessible(authoredUser, typeActivitiesList);
        return ResponseEntityWrapper.wrapperOk(permissionCheckResultList);
    }

    private AuthoredUser getAuthoredUser() {
        return null != AppAuthContextHolder.getContext().getAuthoredUser() ? AppAuthContextHolder.getContext().getAuthoredUser() : AppAuthContextHolder.getContext().getProxyAuthoredUser();
    }
}
