package com.digiwin.athena.base.presentation.server.web.tenantconfig;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.service.tenantconfig.TenantConfigService;
import com.digiwin.athena.base.infrastructure.meta.po.tenantconfig.TenantConfigPO;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * TenantConfigController Description
 *
 * @author majianfu
 * @date 2021/7/13
 * @since
 */
@RestController
@RequestMapping(value = "/api/audc/v1/tenant/config")
public class TenantConfigController {
    @Resource
    private TenantConfigService tenantConfigService;

    /**
     * 获取租户级别配置
     *
     * @param tenantId     租户ID，可选，不传则为当前登录租户ID
     * @param category     配置类型or配置名称
     * @param authoredUser 当前登录用户鉴权信息
     * @return
     */
    @GetMapping("")
    public ResponseEntity<?> getTenantConfig(@RequestParam(value = "tenantId", required = false) String tenantId, @RequestParam(value = "category") String category
            , @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser authoredUser) {
        TenantConfigPO tenantConfig = tenantConfigService.getTenantConfig(authoredUser, tenantId, category);
        return ResponseEntityWrapper.wrapperOk(tenantConfig);
    }
}
