package com.digiwin.athena.base.presentation.server.web.trial;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.trial.apply.TrialApplyReq;
import com.digiwin.athena.base.application.service.trial.TrialApplyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/08/30 15:18:46
 */

@Slf4j
@RestController
@RequestMapping(value = "/api/trial/apply")
public class TrialApplyController {

    private final TrialApplyService trialApplyService;

    /**
     * 构造函数注入业务处理类
     *
     * @param trialApplyService trialApplyService
     */
    @Autowired
    public TrialApplyController(TrialApplyService trialApplyService) {
        this.trialApplyService = trialApplyService;
    }

    /**
     * 试用申请提交
     *
     * @return ResponseEntity
     */
    @PostMapping(value = "/submit", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> applyInfoSubmit(@RequestBody TrialApplyReq req, HttpServletRequest request) {

        int result = trialApplyService.dealApplyInfo(req);
        return ResponseEntityWrapper.wrapperOk(result);
    }
}
