package com.digiwin.athena.base.presentation.server.web.action;


import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.atdm.action.executor.DataSubmissionServiceWrapper;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@RestController
@RequestMapping(value = "/api/atdm/v1/action/")
public class ActionExecuteController {
    @Autowired
    private DataSubmissionServiceWrapper dataSubmissionServiceWrapper;

    /**
     * 仅执行action
     * <br>不会判断是否处理完成
     * <br>不会关闭待办等
     */
    @PostMapping(value = {"/execute", "/open/execute"}, produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> executeAction(HttpServletRequest request, @RequestBody SubmitActionDTO submitAction) {
        return ResponseEntityWrapper.wrapperOk(dataSubmissionServiceWrapper.executeAction(request, submitAction));
    }

}
