package com.digiwin.athena.base.presentation.server.web.action;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.service.action.EspApiCallbackService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@RestController
@RequestMapping(value = "/api/atdm/v1/action/api/error/info")
public class EspApiCallbackController {

    @Autowired
    private EspApiCallbackService espApiCallbackService;

    /**
     * 回调
     * @param request
     * @param data
     * @return
     */
    @PostMapping(value = "/callback", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> executeAction(HttpServletRequest request, @RequestBody String data) {
        log.error("EspApiCallbackController-data:{}", JsonUtils.objectToString(data));
        log.error("EspApiCallbackController-request:{}", request);
        espApiCallbackService.callback(request, data);
        return ResponseEntityWrapper.wrapperOk();
    }

}
