package com.digiwin.athena.base.presentation.server.web.permission;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.service.permission.PermissionService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * PermissionController Description
 * 权限接口--获取应用权限配置
 *
 * @author majianfu
 * @date 2022/5/16
 * @since
 */
@RestController
@RequestMapping(value = "api/audc")
public class PermissionController {
    @Resource
    private PermissionService permissionService;

    /**
     * 获取用户授权所有应用的权限配置
     *
     * @param authoredUser
     * @return
     */
    @GetMapping("/v1/user/authored/app/permission")
    public ResponseEntity<?> getUserAuthoredAppPermission(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser authoredUser) {
        return ResponseEntityWrapper.wrapperOk(permissionService.getUserAuthoredAppPermission(authoredUser));
    }

    @GetMapping("/v1/user/authored/app/permission/appCode")
    public ResponseEntity<?> getUserAuthoredAppPermissionByAppCode(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser authoredUser,
                                                                   @RequestParam(value = "appCode", required = false) String appCode) {
        return ResponseEntityWrapper.wrapperOk(permissionService.getUserAuthoredAppPermissionByAppCode(authoredUser,appCode));
    }
}
