package com.digiwin.athena.base;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.digiwin.loadbalance.scan.DWPathScan;
import com.jugg.agile.framework.core.dapper.alarm.JaNotify;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@DWPathScan
@EnableScheduling
@EnableAsync(proxyTargetClass = true)
@SpringBootApplication(exclude = {MongoAutoConfiguration.class, DataSourceAutoConfiguration.class, DruidDataSourceAutoConfigure.class}
,scanBasePackages={"com.digiwin.athena.atdm", "com.digiwin.athena.base"})
public class Application {

    public static void main(String[] args) throws Throwable {
        JaNotify.notifyRun(() -> SpringApplication.run(Application.class, args));
    }
}
