package com.digiwin.athena.base.presentation.server.web.cache;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.base.infrastructure.manager.thememap.BaseThemeMapService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.lang.reflect.InvocationTargetException;

@RestController
@RequestMapping("mytest")
public class MyTestController {

    @Autowired
    BaseThemeMapService baseThemeMapService;

    @RequestMapping("test01")
    public Object test01(){

        baseThemeMapService.checkActivityAppExpired("PR_4a912e0210001ac4","activity");
        return "ok";
    }

    @PostMapping ("/test/gateway/millisecond/500")
    public Object testGateway500Millisecond() throws InterruptedException{
        Thread.sleep(500);
        return "success";
    }

    @PostMapping("/test/gateway/second/3")
    public Object testGateway3Second() throws InterruptedException{
        Thread.sleep(3000);
        return "success";
    }

    @PostMapping("/test/gateway/large/json")
    public Object testGatewayLargeJson(@RequestBody JSONObject request) throws InterruptedException, InvocationTargetException, IllegalAccessException {
        int times = request.getInteger("times");
        long sleepTime = request.getLong("sleepTime");

        for (int i = 0; i < times; i++) {
            BeanUtils.copyProperties(new JSONObject(), request);
            Thread.sleep(sleepTime);
        }
        return "success";
    }
}
