package com.digiwin.athena.base.presentation.server.web.calendar;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.service.calendar.CalendarService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * CalendarController Description
 *
 * @author majianfu
 * @date 2022/8/17
 * @since
 */
@RestController
@RequestMapping("/api/audc/v1/calendar")
public class CalendarController {
    @Autowired
    private CalendarService calendarService;

    /**
     * 查询行事历“任务名称”下拉选项列表
     *
     * @param authoredUser
     * @param excludeCategories
     * @return
     */
    @GetMapping("/task")
    public ResponseEntity<?> queryCalendarTaskList(@RequestAttribute(GlobalConstant.AUTH_USER) AuthoredUser authoredUser
            , @RequestParam(value = "excludeCategory", required = false) List<String> excludeCategories) {
        return ResponseEntityWrapper.wrapperOk(calendarService.queryCalendarTaskList(authoredUser, excludeCategories));
    }

    /**
     * 41603新增方法
     * 获取用户拥有的行事历任务类型
     * @return
     */
    @GetMapping("/queryCalendarTaskList")
    public ResponseEntity<?> queryCalendarTaskList() {
        return ResponseEntityWrapper.wrapperOk(calendarService.queryCalendarTaskList());
    }

}
