package com.digiwin.athena.base.presentation.server.web.recycle;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.atdm.recycle.CommonRecycleService;
import com.digiwin.athena.atdm.recycle.dto.RecycleRecordStateChangeDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/api/atdm/v1/recycle/")
public class RecycleController {

    @Autowired
    private CommonRecycleService commonRecycleService;

    /**
     * 回收站总数
     *
     * @return
     */
    @PostMapping("count/by/tenantId")
    public ResponseEntity<?> queryRecycleCount() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        int recycleCount = commonRecycleService.getRecycleCount(tenantId);
        return ResponseEntityWrapper.wrapperOk(recycleCount);
    }

    /**
     * 获取回收站左侧列表
     *
     * @return
     */
    @PostMapping("query/list")
    public ResponseEntity<?> queryRecycleList() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List<Map<String, Object>> recycleList = commonRecycleService.queryActivityList(tenantId);
        return ResponseEntityWrapper.wrapperOk(recycleList);
    }

    /**
     * 删除该租户下回收站所有数据
     *
     * @return
     */
    @DeleteMapping(value = "deleteAll")
    public ResponseEntity<?> deleteAll() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        commonRecycleService.deleteAll(tenantId);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 将回收站记录标记为过期状态
     *
     * @param recycleRecordStateChangeDTO
     * @return
     */
    @PostMapping(value = "state/expired")
    public ResponseEntity<?> markExpired(@RequestBody @Validated RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        commonRecycleService.markExpired(recycleRecordStateChangeDTO);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 将回收站记录标记为未过期状态
     *
     * @param recycleRecordStateChangeDTO
     * @return
     */
    @PostMapping(value = "state/unexpired")
    public ResponseEntity<?> markUnexpired(@RequestBody @Validated RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        commonRecycleService.markUnexpired(recycleRecordStateChangeDTO);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 将回收站记录标记为删除状态（硬删除）
     *
     * @param recycleRecordStateChangeDTO
     * @return
     */
    @PostMapping(value = "/state/deleted")
    public ResponseEntity<?> markDeleted(@RequestBody @Validated RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        commonRecycleService.markDeleted(recycleRecordStateChangeDTO);
        return ResponseEntityWrapper.wrapperOk();
    }
}
