package com.digiwin.athena.base.presentation.server.web.trial;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.trial.TrialSceneCardMapper;
import com.digiwin.athena.base.infrastructure.meta.po.trial.SceneCardData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/28 09:24:11
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/scene/back")
public class SceneBackController {

    private final TrialSceneCardMapper trialSceneCardMapper;

    @Autowired
    public SceneBackController(TrialSceneCardMapper trialSceneCardMapper)
    {
        this.trialSceneCardMapper = trialSceneCardMapper;
    }

    /**
     * 获取场景或者步骤对应的步骤id
     *
     * @return ResponseEntity
     */
    @GetMapping(value = "/query", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> query(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                             @RequestParam(value = "sceneId", required = false) Long sceneId,
                                             @RequestParam(value = "stepId", required = false) Long stepId) {

        if(Objects.isNull(sceneId) && Objects.isNull(stepId))
        {
            //缺少参数
            return ResponseEntityWrapper.wrapperOk(-1);
        }
        QueryWrapper<SceneCardData> queryWrapper = new QueryWrapper<>();
        if(!Objects.isNull(sceneId))
        {
            queryWrapper.eq("scene_id",sceneId);
        }
        if(!Objects.isNull(stepId))
        {
            queryWrapper.eq("step_id",stepId);
        }
        queryWrapper.eq("user_id",user.getUserId());
        queryWrapper.eq("tenant_id",user.getTenantId());
        queryWrapper.orderByDesc("create_date");
        List<SceneCardData> list = trialSceneCardMapper.selectList(queryWrapper);
        if(list!=null && !list.isEmpty())
        {
             return ResponseEntityWrapper.wrapperOk(list.get(0));
        }
        return ResponseEntityWrapper.wrapperOk(Collections.EMPTY_LIST);
    }
}
