package com.digiwin.athena.base.presentation.server.web.importstatistics;

import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.dto.DownloadHistoryProjectTaskParamDTO;
import com.digiwin.athena.base.application.service.importstatistics.HistoryProjectTaskServiceImpl;
import com.digiwin.athena.base.sdk.common.application.util.MessageUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 历史项目/任务
 *
 * @author xuhx
 * @date 2025/5/15
 */
@RestController
@RequestMapping("/historyProjectTask")
//@CrossOrigin
@Slf4j
public class HistoryProjectTaskInterface {

    @Autowired
    HistoryProjectTaskServiceImpl historyProjectTaskService;


    /**
     * 发起下载
     * 历史项目任务明细
     *
     * @param downloadHistoryProjectTaskParamDTO
     * @return
     */
    @PostMapping("/startDownloadHistoryData")
    public DapResponse startDownloadHistoryData(@RequestBody DownloadHistoryProjectTaskParamDTO downloadHistoryProjectTaskParamDTO) {
        if (Boolean.TRUE.equals(historyProjectTaskService.startDownloadHistoryData(downloadHistoryProjectTaskParamDTO))) {
            return DapResponse.ok();
        } else {
            return DapResponse.failed(MessageUtil.getMessage("delivery.exportDataError"));
        }
    }
}
