package com.digiwin.athena.base.presentation.server.web.visit;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.config.BaseAudcDataSourceConfig;
import com.digiwin.athena.base.application.meta.request.visit.VisitInfoReq;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.mapper.audc.visit.VisitInfoMapper;
import com.digiwin.athena.base.infrastructure.meta.po.visit.VisitInfoData;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/11/04 13:51:38
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/visit")
public class VisitController {

    private VisitInfoMapper visitInfoMapper;

    @Autowired
    public VisitController(VisitInfoMapper visitInfoMapper) {
        this.visitInfoMapper = visitInfoMapper;
    }

    /**
     * 配置提交
     *
     * @return ResponseEntity
     */
    @Transactional(transactionManager = BaseAudcDataSourceConfig.BASE_AUDC_DATASOURCE_TRANSACTION_MANAGER_BUSINESS)
    @PostMapping(value = "/submit", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> submitInfo(@RequestBody VisitInfoReq req, @RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user) {

        if (StringUtils.isEmpty(req.getModuleNo())) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException("Module No must not be empty.");
        }
        VisitInfoData data = new VisitInfoData();
        BeanUtils.copyProperties(req, data);
        data.setId(SnowflakeIdWorker.getInstance().newId());
        data.setCreateDate(LocalDateTime.now());
        data.setModifyDate(LocalDateTime.now());
        data.setUserId(user.getUserId());
        data.setUserName(user.getUserName());
        data.setTenantId(user.getTenantId());
        // 插入数据 or 根据联合索引（user_id、tenant_id、module_no）更新数据
        int result = visitInfoMapper.insertOrUpdateVisitInfo(data);
        return ResponseEntityWrapper.wrapperOk(result);
    }

    /**
     * 配置查询
     * moduleNo 解释：  task-sort-config：我的任务；project-sort-config-我的项目；team-task-sort-config:团队任务；team-project-sort-config-团队项目
     *
     * @return ResponseEntity
     */
    @GetMapping(value = "/query", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> query(@RequestParam(name = "moduleNo") String moduleNo, @RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user) {

        //查询暂不依赖于租户信息
        QueryWrapper<VisitInfoData> query = new QueryWrapper<>();
        query.eq("module_no", moduleNo);
        query.eq("user_id", user.getUserId());
        query.eq("tenant_id", user.getTenantId());
        //query.eq("tenant_id",user.getTenantId());
        VisitInfoData result = visitInfoMapper.selectOne(query);
        // 待办桌面改版，排序用户记忆 这些 moduleNo 需要兼容老数据
        boolean isSpecialModuleNo = "task-sort-config".equals(moduleNo)
                || "project-sort-config".equals(moduleNo)
                || "team-task-sort-config".equals(moduleNo)
                || "team-project-sort-config".equals(moduleNo);

        if (isSpecialModuleNo) {
            convertHistoryDetailSpecialModuleNo(result);
        }

        return ResponseEntityWrapper.wrapperOk(result);
    }

    private void convertHistoryDetailSpecialModuleNo(VisitInfoData result) {
        try {
            if (null != result && StringUtils.isNotEmpty(result.getDetail())) {
                /*
                 * 此处为了满足架构兼容历史用户记忆配置
                 * 历史数据格式：{"all":[{"selectedOption":"setLabelFront","type":"label","switch":false},{"selectedOption":"taskTypeFront","type":"taskType","switch":false},{"selectedOption":"readStatusUnread","defaultOption":"readStatusUnread","type":"readStatus","switch":false},{"selectedOption":"timeEndTimeAsc","defaultOption":"timeEndTimeAsc","type":"time","switch":false}]}
                 * 逻辑是：1.移除switch为false的；2.如：selectedOption中的readStatusUnread -> asc，readStatusRead -> desc
                 */
                Map<String, Object> detailMap = Maps.newHashMap();
                if (JSONUtil.isJsonObj(result.getDetail())) {
                    JSONObject jsonObject = JSONUtil.parseObj(result.getDetail());
                    JSONArray jsonArray = (JSONArray) jsonObject.get("all");
                    List<Map<String, Object>> list = Lists.newArrayList();
                    if (null != jsonArray && jsonArray.size() > 0) {
                        JSONObject detail = (JSONObject) jsonArray.get(0);
                        if (detail.containsKey("selectedOption")) {
                            // json体中包含 selectedOption 属性，是历史数据
                            return;
                        }
                        for (Object obj : jsonArray) {
                            Map<String, Object> map = Maps.newHashMap();
                            JSONObject j = (JSONObject) obj;
                            String paramName = j.getStr("paramName");
                            if ("READ_STATUS".equals(paramName)) {

                                String sortType = j.getStr("sortType");
                                if ("desc".equals(sortType)) {
                                    map.put("type", "readStatus");
                                    map.put("selectedOption", "readStatusUnread");
                                    map.put("defaultOption", "readStatusUnread");
                                    map.put("swith", true);
                                } else if ("asc".equals(sortType)) {
                                    map.put("type", "readStatus");
                                    map.put("selectedOption", "readStatusRead");
                                    map.put("defaultOption", "readStatusRead");
                                    map.put("swith", true);
                                }
                            } else if ("FINISH_TIME".equals(paramName)) {

                                String sortType = j.getStr("sortType");
                                if ("desc".equals(sortType)) {
                                    map.put("type", "time");
                                    map.put("selectedOption", "timeEndTimeDesc");
                                    map.put("defaultOption", "timeEndTimeDesc");
                                    map.put("swith", true);
                                } else if ("asc".equals(sortType)) {
                                    map.put("type", "time");
                                    map.put("selectedOption", "timeEndTimeAsc");
                                    map.put("defaultOption", "timeEndTimeAsc");
                                    map.put("swith", true);
                                }
                            } else if ("TIME".equals(paramName)) {
                                String sortType = j.getStr("sortType");
                                if ("asc".equals(sortType)) {
                                    JSONArray cascaderModel = j.getJSONArray("cascaderModel");
                                    if (cascaderModel.size() > 1) {
                                        Object o = cascaderModel.get(1);
                                        if (o != null && o.toString().equals("endTime")) {
                                            map.put("type", "time");
                                            map.put("selectedOption", "projectTimeEndTimeAsc");
                                            map.put("defaultOption", "projectTimeEndTimeAsc");
                                            map.put("swith", true);
                                        }
                                    }

                                } else if ("desc".equals(sortType)) {
                                    JSONArray cascaderModel = j.getJSONArray("cascaderModel");
                                    if (cascaderModel.size() > 1) {
                                        Object o = cascaderModel.get(1);
                                        if (o != null && o.toString().equals("endTime")) {
                                            map.put("type", "time");
                                            map.put("selectedOption", "projectTimeEndTimeDesc");
                                            map.put("defaultOption", "projectTimeEndTimeDesc");
                                            map.put("swith", true);
                                        }
                                    }

                                }
                            } else if ("NAME".equals(paramName)) {

                                String sortType = j.getStr("sortType");
                                if ("desc".equals(sortType)) {
                                    map.put("type", "name");
                                    map.put("selectedOption", "projectNameDesc");
                                    map.put("defaultOption", "projectNameDesc");
                                    map.put("swith", true);
                                } else if ("asc".equals(sortType)) {
                                    map.put("type", "name");
                                    map.put("selectedOption", "projectNameAsc");
                                    map.put("defaultOption", "projectNameAsc");
                                    map.put("swith", true);
                                }
                            } else if ("OVERDUE_EXCEPTION".equals(paramName)) {

                                String sortType = j.getStr("sortType");
                                if ("desc".equals(sortType)) {
                                    map.put("type", "overdueException");
                                    map.put("selectedOption", "overdueExceptionOff");
                                    map.put("defaultOption", "overdueExceptionOff");
                                    map.put("swith", true);
                                } else if ("asc".equals(sortType)) {
                                    map.put("type", "overdueException");
                                    map.put("selectedOption", "overdueExceptionOn");
                                    map.put("defaultOption", "overdueExceptionOn");
                                    map.put("swith", true);
                                }
                            } else if ("TASK_TYPE".equals(paramName)) {
                                map.put("type", "taskType");
                                map.put("selectedOption", "taskTypeFront");
                                map.put("swith", true);
                            } else {
                                map.put("type", "label");
                                map.put("selectedOption", "setLabelFront");
                                map.put("switch", true);
                            }
                            list.add(map);
                        }


                        detailMap.put("all", list);
                        result.setDetail(JSONUtil.toJsonStr(detailMap));
                    }
                }
            }
        } catch (Exception ex) {
            // 此处是兼容历史记忆，防止有些脏数据/历史数据格式不兼容，导致转换报错，保证页面主流程继续往下走
            log.error("convert history error", ex);
        }

    }

    @GetMapping(value = "/query/order", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> queryOrder(@RequestParam(name = "moduleNo") String moduleNo, @RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user) {

        //查询暂不依赖于租户信息
        QueryWrapper<VisitInfoData> query = new QueryWrapper<>();
        query.eq("module_no", moduleNo);
        query.eq("user_id", user.getUserId());
        query.eq("tenant_id", user.getTenantId());
        //query.eq("tenant_id",user.getTenantId());
        VisitInfoData result = visitInfoMapper.selectOne(query);
        return ResponseEntityWrapper.wrapperOk(result);
    }
}
