/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.attachment;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.attachment.AttachUploadedCountDTO;
import com.digiwin.athena.base.application.meta.request.attachment.AttachmentDownloadReqDTO;
import com.digiwin.athena.base.application.meta.request.attachment.AttachmentReqDTO;
import com.digiwin.athena.base.application.meta.request.attachment.DeleteAttachmentReqDTO;
import com.digiwin.athena.base.application.meta.request.attachment.UploadOrDeleteAttachmentReqDTO;
import com.digiwin.athena.base.application.meta.request.attachment.UploadParamDTO;
import com.digiwin.athena.base.application.service.attachment.AttachmentService;
import com.digiwin.athena.base.sdk.aam.application.meta.request.QueryAttachmentReqDTO;
import com.digiwin.athena.base.sdk.aam.application.meta.validator.ValidateGroup;
import com.digiwin.athena.base.sdk.common.application.annotation.ElementNotBlank;
import com.jugg.agile.framework.core.dapper.meta.Dapper;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9644\u4ef6CRUD\u3001\u4e0a\u4f20\u3001\u4e0b\u8f7d\u7b49"})
@RestController
@RequestMapping(value={"/api/aam/v1"})
@Validated
public class AttachmentController {
    @Autowired
    private AttachmentService attachmentService;

    @PostMapping(value={"/uploadAttachment", "/open/uploadAttachment"})
    public ResponseEntity<?> uploadAttachmentFile(@RequestBody @Validated(value={ValidateGroup.Save.class}) AttachmentReqDTO attachmentFile) {
        if (this.attachmentService.checkUploadCount(attachmentFile)) {
            return ResponseEntityWrapper.wrapperOk((Object)-1);
        }
        this.attachmentService.saveAttachment(attachmentFile);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/deleteAttachment", "/open/deleteAttachment"})
    public ResponseEntity<?> deleteAttachmentFile(@RequestBody @Validated(value={ValidateGroup.Delete.class}) AttachmentReqDTO attachmentFile) {
        this.attachmentService.deleteAttachment(attachmentFile);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/attachment"})
    public ResponseEntity<?> queryAttachmentFile(@RequestParam(value="tenantId", required=false) String tenantId, @RequestParam(value="taskId") String taskId, @RequestParam(value="projectId", required=false) String projectId, @ElementNotBlank @RequestParam(value="category") List<String> category, @ElementNotBlank @RequestParam(value="rowDataKey") List<String> rowDataKey) {
        List attachmentEntities = this.attachmentService.queryByTaskIdAndRowDataKeyList(tenantId, taskId, projectId, category, rowDataKey);
        return ResponseEntityWrapper.wrapperOk((Object)attachmentEntities);
    }

    @PostMapping(value={"/attachment"})
    public ResponseEntity<?> queryAttachmentFileV2(@Valid @RequestBody QueryAttachmentReqDTO queryAttachmentReqDTO) {
        List attachmentEntities = this.attachmentService.queryByTaskIdAndRowDataKeyList(queryAttachmentReqDTO);
        return ResponseEntityWrapper.wrapperOk((Object)attachmentEntities);
    }

    @Dapper(skip=true)
    @PostMapping(value={"/uploadOrDeleteAttachment"})
    public ResponseEntity<?> uploadOrDeleteAttachment(@RequestBody UploadOrDeleteAttachmentReqDTO uploadOrDeleteAttachmentReqDTO) {
        this.attachmentService.uploadOrDeleteAttachment(uploadOrDeleteAttachmentReqDTO);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/deleteAttachmentBatch"})
    public ResponseEntity<?> deleteAttachmentBatch(@RequestBody DeleteAttachmentReqDTO deleteAttachmentReqDTO) {
        this.attachmentService.deleteAttachmentBatch(deleteAttachmentReqDTO);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Dapper(skip=true)
    @PostMapping(value={"/uploadAndShareAttachmentByUrl"})
    public ResponseEntity<?> uploadAndShareAttachmentByUrl(@RequestBody UploadParamDTO uploadParamDTO) {
        return ResponseEntityWrapper.wrapperOk((Object)this.attachmentService.uploadAttachmentByUrl(uploadParamDTO));
    }

    @Dapper(skip=true)
    @PostMapping(value={"/uploadAgileReport"})
    public ResponseEntity<?> uploadAgileReportByUrl(@RequestBody UploadParamDTO uploadParamDTO) {
        return ResponseEntityWrapper.wrapperOk((Object)this.attachmentService.uploadAgileReport(uploadParamDTO));
    }

    @GetMapping(value={"/getAgileReportInfo"})
    public ResponseEntity<?> getAgileReportInfo(@RequestParam(value="fileId") String fileId) {
        return ResponseEntityWrapper.wrapperOk((Object)this.attachmentService.getFile(fileId));
    }

    @GetMapping(value={"/deleteAgileReportInfo"})
    public ResponseEntity<?> deleteAgileReportInfo(@RequestParam(value="fileId") String fileId) {
        return ResponseEntityWrapper.wrapperOk((Object)this.attachmentService.deleteFile(fileId));
    }

    @PostMapping(value={"/attachUploadedCount"})
    public ResponseEntity<?> attachUploadedCount(@RequestBody AttachUploadedCountDTO attachUploadedCountDTO) {
        return ResponseEntityWrapper.wrapperOk((Object)this.attachmentService.attachUploadedCount(attachUploadedCountDTO));
    }

    @PostMapping(value={"/download"})
    public Object download(@RequestBody AttachmentDownloadReqDTO attachmentDownloadReqDTO) {
        if (CollectionUtils.isNotEmpty((Collection)attachmentDownloadReqDTO.getFileIds())) {
            return this.attachmentService.batchDownload(attachmentDownloadReqDTO);
        }
        return this.attachmentService.download(attachmentDownloadReqDTO);
    }

    @PostMapping(value={"/downloadImageWatermarkBase64"})
    public Object downloadImageWatermarkBase64(@RequestBody List<AttachmentDownloadReqDTO> attachmentDownloadReqDTOList) {
        return this.attachmentService.downloadImageWatermarkBase64(attachmentDownloadReqDTOList);
    }
}

