/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.commonused;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.dto.commonused.CardGroupGroup;
import com.digiwin.athena.base.application.meta.dto.commonused.CategoriesDto;
import com.digiwin.athena.base.application.meta.dto.commonused.ItemsDto;
import com.digiwin.athena.base.application.meta.dto.commonused.SourceType;
import com.digiwin.athena.base.application.meta.dto.commonused.SystemWSConditionVO;
import com.digiwin.athena.base.application.meta.dto.commonused.WSConditionVO;
import com.digiwin.athena.base.application.meta.request.commonused.BatchAddItemReq;
import com.digiwin.athena.base.application.meta.request.commonused.BatchSortItemReq;
import com.digiwin.athena.base.application.meta.request.commonused.CategoryReq;
import com.digiwin.athena.base.application.meta.request.commonused.CheckUsedReq;
import com.digiwin.athena.base.application.meta.request.commonused.ItemReq;
import com.digiwin.athena.base.application.meta.request.commonused.MenuAuthorityReq;
import com.digiwin.athena.base.application.meta.request.commonused.TaskCardGroupReq;
import com.digiwin.athena.base.application.meta.request.commonused.TaskCardListConfigReq;
import com.digiwin.athena.base.application.meta.response.commonused.CateAndItemResp;
import com.digiwin.athena.base.application.meta.response.commonused.CategoryResp;
import com.digiwin.athena.base.application.meta.response.commonused.CheckUsedResp;
import com.digiwin.athena.base.application.meta.response.commonused.ItemResp;
import com.digiwin.athena.base.application.service.commonused.CategoryService;
import com.digiwin.athena.base.application.service.commonused.CommonUsedService;
import com.digiwin.athena.base.application.service.commonused.DataMigrationService;
import com.digiwin.athena.base.application.service.commonused.ItemService;
import com.digiwin.athena.base.application.service.commonused.MenuService;
import com.digiwin.athena.base.application.service.commonused.TaskCardGroupService;
import com.digiwin.athena.base.application.service.commonused.TaskCardListConfigService;
import com.digiwin.athena.base.application.util.LanguageUtil;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.manager.atmc.BaseAtmcService;
import com.digiwin.athena.base.infrastructure.manager.thememap.BaseThemeMapService;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.TaskCardListConfigMapper;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.CategoryData;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.CustomTaskCardGroupData;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.ItemData;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.TaskCardListConfigData;
import com.google.common.collect.Lists;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;
import net.sf.json.JSONArray;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RestController
@RequestMapping(value={"/api/amtc/v1/commonUsed"})
public class CommonUsedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonUsedController.class);
    @Autowired
    private CommonUsedService commonUsedService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private MenuService menuService;
    @Autowired
    private DataMigrationService dataMigrationService;
    @Autowired
    private TaskCardListConfigService taskCardListConfigService;
    @Autowired
    TaskCardListConfigMapper taskCardListConfigMapper;
    @Autowired
    private TaskCardGroupService taskCardGroupService;
    @Autowired
    BaseThemeMapService baseThemeMapService;
    @Autowired
    BaseAtmcService baseAtmcService;
    public static final String TASK_ON_OFF = "taskOnOff";
    public static final String TASK_CARD_WHITE_LIST = "taskCardWhiteList";

    @GetMapping(value={"/list"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> cateAndItemList(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="plat") Integer plat, @RequestParam(value="cateId", required=false) Long cateId) {
        CateAndItemResp resp = this.commonUsedService.cateAndItemList(user, plat, cateId);
        String defaultUnfold = this.categoryService.queryDefaultUnfold(user, plat);
        resp.setDefaultUnfold(defaultUnfold);
        return ResponseEntityWrapper.wrapperOk((Object)resp);
    }

    @PostMapping(value={"/cate/add"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> addCategory(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody CategoryReq cateReq) {
        CategoriesDto cateDto = new CategoriesDto();
        BeanUtils.copyProperties((Object)cateReq, (Object)cateDto);
        if (this.categoryService.isCategoryExist(user, cateDto)) {
            throw BusinessException.create((Integer)-1, (String)"New Category Is Exist");
        }
        CategoryData data = this.categoryService.addCategory(user, cateDto);
        CategoryResp cateResp = new CategoryResp();
        if (null != data) {
            BeanUtils.copyProperties((Object)data, (Object)cateResp);
        }
        return ResponseEntityWrapper.wrapperOk((Object)cateResp);
    }

    @GetMapping(value={"/cate/moveAndDel"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> deleteCategoryAndMoveItems(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="plat") Integer plat, @RequestParam(value="id") Long id) {
        if (id == -1L) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"This Category is Root,Deletion not allowed");
        }
        int result = this.commonUsedService.deleteCateAndMoveItems(user, id, plat);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/cate/delete"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> deleteCategory(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="plat") Integer plat, @RequestParam(value="id") Long id) {
        if (id == -1L) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"This Category is Root,Deletion not allowed");
        }
        int result = this.commonUsedService.deleteCommUsedCate(user, id, plat);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/cate/rename"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> cateRename(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="id") Long id, @RequestParam(value="cateName") String cateName) {
        CategoryData cateData = this.categoryService.detail(id);
        if (null == cateData) {
            throw AudcErrorCodeEnum.COMMON_USED_CATEGORY_NOT_EXIST.getBusinessException("Category Info Not Exist");
        }
        CategoriesDto dto = new CategoriesDto();
        dto.setCateName(cateName);
        dto.setParentId(cateData.getParentId());
        dto.setPlat(cateData.getPlat());
        if (this.categoryService.isCategoryExist(user, dto)) {
            throw BusinessException.create((Integer)-1, (String)"Change CategoryName Is Exist");
        }
        int result = this.categoryService.renameCategory(user, id, cateName);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @PostMapping(value={"/item/add"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> addItem(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody ItemReq itemReq) {
        ItemsDto itemDto = new ItemsDto();
        BeanUtils.copyProperties((Object)itemReq, (Object)itemDto);
        ItemResp resp = new ItemResp();
        ItemData data = this.itemService.addItem(user, itemDto);
        if (null != data) {
            BeanUtils.copyProperties((Object)data, (Object)resp);
        }
        return ResponseEntityWrapper.wrapperOk((Object)resp);
    }

    @GetMapping(value={"/item/move"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> moveItem(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="id") Long id, @RequestParam(value="destCateId") Long destCateId) {
        int result = this.itemService.moveSingleItem(id, destCateId);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @PostMapping(value={"/item/used"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> changeUsed(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody ItemReq itemReq) {
        itemReq.setCateId(Long.valueOf(-1L));
        return this.addItem(user, itemReq);
    }

    @GetMapping(value={"/item/unused"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> changeUsed(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="id", required=false) Long id, @RequestParam(value="itemCode", required=false) String itemCode, @RequestParam(value="plat", required=false) Integer plat) {
        int result = null == id ? this.itemService.delete(user, plat, itemCode) : this.itemService.delete(user, id);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/item/detail"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> itemDetail(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="itemCode") String itemCode, @RequestParam(value="plat") Integer plat) {
        ItemData data = this.itemService.detail(user, itemCode, plat);
        ItemResp resp = new ItemResp();
        if (null != data) {
            Map baseItemMaps = this.commonUsedService.queryEntryData(user, plat);
            BeanUtils.copyProperties((Object)data, (Object)resp);
            resp.setItemName(MapUtils.getString((Map)baseItemMaps, (Object)resp.getItemCode(), (String)""));
        }
        return ResponseEntityWrapper.wrapperOk((Object)resp);
    }

    @GetMapping(value={"/item/checkUsed"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> checkUsed(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="plat") Integer plat, @RequestParam(value="itemCode") String itemCode) {
        boolean result = this.itemService.checkUsed(user, plat, itemCode);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @PostMapping(value={"/item/operate/record"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> operateRecord(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody ItemReq itemReq) {
        ItemsDto itemDto = new ItemsDto();
        BeanUtils.copyProperties((Object)itemReq, (Object)itemDto);
        int result = this.itemService.itemRecord(user, itemDto, 0);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @PostMapping(value={"/item/batch/add"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> batchAddItems(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody List<ItemReq> itemReqs) {
        if (CollectionUtils.isNotEmpty(itemReqs)) {
            for (ItemReq itemReq : itemReqs) {
                ItemsDto itemDto = new ItemsDto();
                BeanUtils.copyProperties((Object)itemReq, (Object)itemDto);
                ItemData data = this.itemService.addItem(user, itemDto);
                ItemResp resp = new ItemResp();
                if (null == data) continue;
                BeanUtils.copyProperties((Object)data, (Object)resp);
            }
            return ResponseEntityWrapper.wrapperOk((Object)1);
        }
        return ResponseEntityWrapper.wrapperOk(new ArrayList());
    }

    @PostMapping(value={"/item/batch/V2/add"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> batchAddItemsV2(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody BatchAddItemReq batchReq) {
        Long cateId = batchReq.getCateId();
        if (Objects.isNull(cateId)) {
            CategoriesDto categoryDto = new CategoriesDto();
            categoryDto.setCateName(batchReq.getCateName());
            categoryDto.setPlat(batchReq.getPlat());
            categoryDto.setParentId(Long.valueOf(-1L));
            if (this.categoryService.isCategoryExist(user, categoryDto)) {
                throw BusinessException.create((Integer)-1, (String)"Category Name Is Exist");
            }
            CategoryData insertResult = this.categoryService.addCategory(user, categoryDto);
            cateId = insertResult.getId();
        }
        if (null != batchReq.getItemList() && !batchReq.getItemList().isEmpty()) {
            for (ItemReq itemReq : batchReq.getItemList()) {
                ItemsDto itemDto = new ItemsDto();
                BeanUtils.copyProperties((Object)itemReq, (Object)itemDto);
                itemDto.setPlat(batchReq.getPlat());
                itemDto.setCateId(cateId);
                ItemData data = this.itemService.addItem(user, itemDto);
                ItemResp resp = new ItemResp();
                if (null == data) continue;
                BeanUtils.copyProperties((Object)data, (Object)resp);
            }
            return ResponseEntityWrapper.wrapperOk((Object)1);
        }
        return ResponseEntityWrapper.wrapperOk(new ArrayList());
    }

    @PostMapping(value={"/item/batch/checkUsed"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> checkUsed(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody CheckUsedReq req) {
        int plat = req.getPlat();
        List codeLists = req.getItemCodes();
        CheckUsedResp resp = new CheckUsedResp();
        resp.setPlat(Integer.valueOf(plat));
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>();
        for (String str : codeLists) {
            boolean result = this.itemService.checkUsed(user, Integer.valueOf(plat), str);
            retMap.put(str, result);
        }
        resp.setCheckResult(retMap);
        return ResponseEntityWrapper.wrapperOk((Object)resp);
    }

    @GetMapping(value={"/tmDataList"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> tmDataList(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, Integer plat, @RequestParam(value="allowRepeat", required=false) Boolean allowRepeat, @RequestParam(required=false) String pattern, @RequestParam(value="effect", required=false) String effect) {
        if (null == allowRepeat) {
            allowRepeat = true;
        }
        return ResponseEntityWrapper.wrapperOk((Object)this.commonUsedService.tmDataList(user, plat, allowRepeat.booleanValue(), Boolean.valueOf(true), null, pattern, effect));
    }

    @GetMapping(value={"/tmStartProject"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> tmStartProject(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.commonUsedService.startProjectList(user, Boolean.valueOf(true), null));
    }

    @GetMapping(value={"/tmTest"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> tmTest(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)JaSpringBeanUtil.getBean((String)"requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        Map map = mapping.getHandlerMethods();
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            String parttenUrl = ((RequestMappingInfo)entry.getKey()).getPatternsCondition().getPatterns().toString();
            String fianlStr = parttenUrl.substring(1, parttenUrl.length() - 1);
            retMap.put(fianlStr, ((HandlerMethod)entry.getValue()).getBeanType().getSimpleName());
        }
        return ResponseEntityWrapper.wrapperOk(retMap);
    }

    @GetMapping(value={"/getCategory"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> getCategory(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="plat") Integer plat, @RequestParam(value="cateId", required=false) Long cateId) {
        if (Objects.isNull(cateId)) {
            cateId = -1L;
        }
        return ResponseEntityWrapper.wrapperOk((Object)this.commonUsedService.finCategory(user, plat, cateId));
    }

    @GetMapping(value={"/menu/query"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> menuTopQuery(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.menuService.query(user));
    }

    @GetMapping(value={"/cate/setTop"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> setCateTop(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="plat") Integer plat, @RequestParam(value="cateId", required=false) Long cateId) {
        return ResponseEntityWrapper.wrapperOk((Object)this.categoryService.setCateTop(user, plat, cateId));
    }

    @GetMapping(value={"/menu/setTop"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> setMenuTop(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="moduleNo") String moduleNo) {
        return ResponseEntityWrapper.wrapperOk((Object)this.menuService.setMenuTop(user, moduleNo));
    }

    @GetMapping(value={"/menu/setUnFold"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> setUnFold(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="moduleNo") String moduleNo, @RequestParam(value="flag") Integer flag) {
        return ResponseEntityWrapper.wrapperOk((Object)this.menuService.setMenuUnfold(user, moduleNo, flag));
    }

    @GetMapping(value={"/cate/unfold"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> cateUnfold(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="cateId", required=false) Long cateId, @RequestParam(value="flag", required=true) Integer flag, @RequestParam(value="plat", required=true) Integer plat) {
        if (cateId == -1L) {
            return ResponseEntityWrapper.wrapperOk((Object)this.categoryService.cateDefaultUnfold(user, plat, flag));
        }
        return ResponseEntityWrapper.wrapperOk((Object)this.categoryService.cateUnfold(user, cateId, flag));
    }

    @PostMapping(value={"/itemList"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> queryItemList(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody ItemReq itemReq) {
        return ResponseEntityWrapper.wrapperOk((Object)this.itemService.queryItemList(user, itemReq.getPlat(), itemReq.getCateId()));
    }

    @GetMapping(value={"/dataMigration/insert"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> dataMigration() {
        return this.dataMigrationService.insertAllCommonUserData();
    }

    @PostMapping(value={"/sort"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> sort(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody @Valid BatchSortItemReq itemReq) {
        this.commonUsedService.saveCustomSort(user, itemReq);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/getTaskCardListConfig"})
    public ResponseEntity<?> getTaskCardListConfig(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="groupId") String groupId) {
        TaskCardListConfigData taskCardListConfigData = (TaskCardListConfigData)this.taskCardListConfigService.getBaseMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TaskCardListConfigData::getTenantId, (Object)user.getTenantId())).eq(TaskCardListConfigData::getUserId, (Object)user.getUserId())).eq(TaskCardListConfigData::getGroupId, (Object)groupId));
        return ResponseEntityWrapper.wrapperOk((Object)(taskCardListConfigData == null ? null : taskCardListConfigData.getConfig()));
    }

    @GetMapping(value={"/getTaskCardListConfigByGroupType"})
    public ResponseEntity<?> getTaskCardListConfigByGroupType(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(value="groupType") Integer groupType, @RequestParam(value="pageCode", required=false) String pageCode) {
        List list = this.taskCardListConfigService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TaskCardListConfigData::getTenantId, (Object)user.getTenantId())).eq(TaskCardListConfigData::getUserId, (Object)user.getUserId())).eq(TaskCardListConfigData::getGroupType, (Object)groupType)).eq(TaskCardListConfigData::getPageCode, (Object)pageCode));
        HashMap result = new HashMap();
        list.forEach(x -> result.put(x.getGroupId(), x.getConfig()));
        return ResponseEntityWrapper.wrapperOk(ObjectUtils.isEmpty(result) ? null : result);
    }

    @PostMapping(value={"saveTaskCardListConfig"})
    public ResponseEntity<?> saveTaskCardListConfig(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody TaskCardListConfigReq taskCardListConfigReq) {
        TaskCardListConfigData taskCardListConfigData = new TaskCardListConfigData();
        taskCardListConfigData.setConfig(taskCardListConfigReq.getConfig());
        taskCardListConfigData.setUserId(user.getUserId());
        taskCardListConfigData.setTenantId(user.getTenantId());
        taskCardListConfigData.setGroupId(taskCardListConfigReq.getGroupId());
        taskCardListConfigData.setGroupType(taskCardListConfigReq.getGroupType());
        taskCardListConfigData.setPageCode(taskCardListConfigReq.getPageCode());
        try {
            TaskCardListConfigData one = this.taskCardListConfigMapper.getOne(taskCardListConfigData.getUserId(), taskCardListConfigData.getTenantId(), taskCardListConfigData.getGroupId(), taskCardListConfigData.getGroupType(), taskCardListConfigData.getPageCode());
            if (one == null) {
                this.taskCardListConfigService.save((Object)taskCardListConfigData);
            } else {
                this.taskCardListConfigMapper.updateConfig(user.getUserId(), user.getTenantId(), taskCardListConfigData.getGroupId(), taskCardListConfigData.getGroupType(), taskCardListConfigData.getConfig(), taskCardListConfigData.getPageCode());
            }
        }
        catch (Exception e) {
            log.error("saveTaskCardListConfig:{},userId:{}", (Object)e.getMessage(), (Object)user.getUserId());
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    @PostMapping(value={"saveSwitchGroupRecord"})
    public ResponseEntity<?> saveSwitchGroupRecord(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody TaskCardGroupReq taskCardGroupReq) {
        CustomTaskCardGroupData customTaskCardGroupData = (CustomTaskCardGroupData)this.taskCardGroupService.getBaseMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomTaskCardGroupData::getUserId, (Object)user.getUserId())).eq(CustomTaskCardGroupData::getTenantId, (Object)user.getTenantId())).eq(CustomTaskCardGroupData::getGroupKey, (Object)taskCardGroupReq.getGroupKey())).eq(CustomTaskCardGroupData::getGroupName, (Object)taskCardGroupReq.getGroupName()));
        if (customTaskCardGroupData == null || customTaskCardGroupData.getGroupName() == null) {
            CustomTaskCardGroupData insertData = new CustomTaskCardGroupData();
            insertData.setGroupName(taskCardGroupReq.getGroupName());
            insertData.setCheckTime(LocalDateTime.now());
            insertData.setUserId(user.getUserId());
            insertData.setGroupKey(taskCardGroupReq.getGroupKey());
            insertData.setPageCode("task");
            insertData.setTenantId(user.getTenantId());
            this.taskCardGroupService.save((Object)insertData);
        } else {
            this.taskCardGroupService.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CustomTaskCardGroupData::getUserId, (Object)user.getUserId())).eq(CustomTaskCardGroupData::getGroupName, (Object)taskCardGroupReq.getGroupName())).eq(CustomTaskCardGroupData::getTenantId, (Object)user.getTenantId())).eq(CustomTaskCardGroupData::getGroupKey, (Object)taskCardGroupReq.getGroupKey())).set(CustomTaskCardGroupData::getPageCode, (Object)"task")).set(CustomTaskCardGroupData::getCheckTime, (Object)LocalDateTime.now()));
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"getGroupRecord"})
    public ResponseEntity<?> getGroupRecord(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Map groupConfig = new HashMap();
        try {
            groupConfig = this.baseThemeMapService.getGroupConfig();
        }
        catch (Exception e2) {
            log.error("KM business Error: {}", (Object)e2.getMessage());
            return ResponseEntityWrapper.wrapperOk((Object)this.generatedDefaultGroup());
        }
        Map groupRule = (Map)groupConfig.get("groupRule");
        cn.hutool.json.JSONArray jsonArray = new cn.hutool.json.JSONArray(groupRule.get("showGroup"));
        List list = this.taskCardGroupService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomTaskCardGroupData::getUserId, (Object)user.getUserId())).eq(CustomTaskCardGroupData::getTenantId, (Object)user.getTenantId())).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(CustomTaskCardGroupData::getPageCode, (Object)"task")).or()).isNull(CustomTaskCardGroupData::getPageCode);
        })).orderByDesc(CustomTaskCardGroupData::getCheckTime)).last("LIMIT 1"));
        List codes = jsonArray.stream().map(e -> ((JSONObject)e).get((Object)"code").toString()).collect(Collectors.toList());
        List<JSONObject> enabledList = jsonArray.stream().filter(e -> "true".equals(((JSONObject)e).get((Object)"enabled").toString())).map(e -> (JSONObject)e).collect(Collectors.toList());
        List isDefault = enabledList.stream().filter(e -> "true".equals(e.get((Object)"defaultEffective").toString())).collect(Collectors.toList());
        if (isDefault.isEmpty()) {
            enabledList.stream().filter(e -> "groupByProjectType".equals(e.get((Object)"code"))).forEach(e -> e.set("defaultEffective", (Object)"true"));
        }
        Boolean aTrue = this.baseAtmcService.verifyConfig(TASK_ON_OFF, "true");
        Boolean aBoolean = this.baseAtmcService.verifyConfig(TASK_CARD_WHITE_LIST, user.getTenantId());
        if (!aTrue.booleanValue() && !aBoolean.booleanValue()) {
            enabledList = enabledList.stream().filter(e -> "system".equals(e.get((Object)"type"))).collect(Collectors.toList());
            return ResponseEntityWrapper.wrapperOk(enabledList);
        }
        if (list.isEmpty()) {
            return ResponseEntityWrapper.wrapperOk(enabledList);
        }
        CustomTaskCardGroupData customTaskCardGroupData = (CustomTaskCardGroupData)list.get(0);
        this.convertMemoryConfig(customTaskCardGroupData);
        String groupKey = customTaskCardGroupData.getGroupKey();
        if (!codes.contains(groupKey)) {
            return ResponseEntityWrapper.wrapperOk(enabledList);
        }
        enabledList.forEach(e -> {
            if ("true".equals(e.get((Object)"defaultEffective").toString())) {
                e.set("defaultEffective", (Object)false);
            }
            if (groupKey.equals(e.get((Object)"code").toString())) {
                e.set("defaultEffective", (Object)true);
            }
        });
        return ResponseEntityWrapper.wrapperOk(enabledList);
    }

    private void convertMemoryConfig(CustomTaskCardGroupData customTaskCardGroupData) {
        try {
            cn.hutool.json.JSONArray normalValue;
            JSONObject jsonObject;
            String model;
            String memoryConfig = customTaskCardGroupData.getMemoryConfig();
            if (JSONUtil.isTypeJSON((String)memoryConfig) && Objects.equals(model = (jsonObject = JSONUtil.parseObj((String)memoryConfig)).getStr((Object)"model"), "normal") && CollectionUtils.isNotEmpty((Collection)(normalValue = jsonObject.getJSONArray((Object)"normalValue")))) {
                Object o = normalValue.get(0);
                JSONObject object = JSONUtil.parseObj((String)JSONUtil.toJsonStr((Object)o));
                String code = object.getStr((Object)"code");
                customTaskCardGroupData.setGroupKey(code);
                customTaskCardGroupData.setGroupName(object.getStr((Object)"name"));
            }
        }
        catch (Exception e) {
            log.error("convertMemoryConfig error,", (Throwable)e);
        }
    }

    private Map<String, Object> generatedDefaultGroupV2(String pageCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String locale = LocaleContextHolder.getLocale().toString();
        if (pageCode.equals("project-card")) {
            List projectGroupWSConditionVO = SystemWSConditionVO.projectGroupWSConditionVO;
            try {
                LanguageUtil.processLocaleLanguage((Object)projectGroupWSConditionVO, (String)locale);
            }
            catch (IllegalAccessException e) {
                log.error("processLocaleLanguage error" + projectGroupWSConditionVO);
            }
            map.put("defaultCondition", projectGroupWSConditionVO);
        } else if (pageCode.equals("task-card")) {
            try {
                JSONArray groupDimension = this.baseAtmcService.getGroupDimension();
                cn.hutool.json.JSONArray cardGroupGroups = JSONUtil.parseArray((String)JSONUtil.toJsonStr((Object)groupDimension));
                try {
                    LanguageUtil.processLocaleLanguage((Object)cardGroupGroups, (String)locale);
                }
                catch (IllegalAccessException e) {
                    log.error("processLocaleLanguage error" + cardGroupGroups);
                }
                List conditionVOS = cardGroupGroups.stream().map(v -> {
                    WSConditionVO wsConditionVO = (WSConditionVO)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)v), WSConditionVO.class);
                    CardGroupGroup cardGroupGroup = (CardGroupGroup)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)v), CardGroupGroup.class);
                    wsConditionVO.setAliasName(cardGroupGroup.getName());
                    wsConditionVO.setAliasCode(cardGroupGroup.getCode());
                    wsConditionVO.setSourceType(SourceType.system);
                    wsConditionVO.setDefaultEffective(Boolean.valueOf(cardGroupGroup.isDefaultEffective()));
                    wsConditionVO.setEnable(Boolean.valueOf(true));
                    return wsConditionVO;
                }).collect(Collectors.toList());
                map.put("defaultCondition", conditionVOS);
            }
            catch (Exception e) {
                log.error("call atmc group record error,", (Throwable)e);
            }
        }
        return map;
    }

    private cn.hutool.json.JSONArray generatedDefaultGroup() {
        JSONArray groupDimension = this.baseAtmcService.getGroupDimension();
        cn.hutool.json.JSONArray result = new cn.hutool.json.JSONArray();
        for (Object o : groupDimension) {
            JSONObject jsonObject = JSONUtil.parseObj(o);
            Object lang = jsonObject.get((Object)"lang");
            JSONObject langJson = JSONUtil.parseObj((Object)lang);
            Object name = langJson.get((Object)"name");
            JSONObject nameJson = JSONUtil.parseObj((Object)name);
            String locale = LocaleContextHolder.getLocale().toString();
            if (locale != null) {
                String nameStr = nameJson.getStr((Object)locale);
                jsonObject.set("name", (Object)nameStr);
            } else {
                String zh_cn = nameJson.getStr((Object)"zh_CN");
                jsonObject.set("name", (Object)zh_cn);
            }
            jsonObject.set("enabled", (Object)true);
            if ("groupByProjectType".equals(jsonObject.getStr((Object)"code"))) {
                jsonObject.set("defaultEffective", (Object)true);
            } else {
                jsonObject.set("defaultEffective", (Object)false);
            }
            result.add((Object)jsonObject);
        }
        return result;
    }

    @GetMapping(value={"groupRecord/{pageCode}"})
    public ResponseEntity<?> getGroupRecordPageCode(@PathVariable(value="pageCode") String oriPageCode, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        String pageCode;
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> removeKey = new HashSet<String>();
        boolean isTask = oriPageCode.equals("task");
        if (isTask || oriPageCode.equals("team-tasks")) {
            pageCode = "task-card";
            if (oriPageCode.equals("task")) {
                removeKey.add("groupByMember");
                removeKey.add("groupByDepartment");
            }
        } else if (oriPageCode.equals("project") || oriPageCode.equals("team-projects")) {
            pageCode = "project-card";
            if (oriPageCode.equals("project")) {
                removeKey.add("groupByMember");
                removeKey.add("groupByDepartment");
            }
        } else {
            return ResponseEntityWrapper.wrapperOk(result);
        }
        Map groupConfig = new HashMap();
        try {
            groupConfig = this.baseThemeMapService.getQueryCondition(pageCode, "groups");
        }
        catch (Exception e) {
            log.error("KM business Error: {}", (Object)e.getMessage());
            groupConfig = this.generatedDefaultGroupV2(pageCode);
        }
        JSONObject jsonObject = new JSONObject(groupConfig);
        cn.hutool.json.JSONArray defaultCondition = jsonObject.getJSONArray((Object)"defaultCondition");
        List objects = this.convertCondition(result, removeKey, defaultCondition);
        ArrayList jsonObjects = Lists.newArrayList((Iterable)objects);
        result.put("options", jsonObjects);
        cn.hutool.json.JSONArray condition = jsonObject.getJSONArray((Object)"condition");
        List objectsCondition = this.convertCondition(result, removeKey, condition);
        result.put("allOptions", objectsCondition);
        try {
            CustomTaskCardGroupData cardGroupData = isTask ? (CustomTaskCardGroupData)this.taskCardGroupService.getBaseMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomTaskCardGroupData::getUserId, (Object)user.getUserId())).eq(CustomTaskCardGroupData::getTenantId, (Object)user.getTenantId())).and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(CustomTaskCardGroupData::getPageCode, (Object)"task")).or()).isNull(CustomTaskCardGroupData::getPageCode);
            })).orderByDesc(CustomTaskCardGroupData::getCheckTime)).last("LIMIT 1")) : (CustomTaskCardGroupData)this.taskCardGroupService.getBaseMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomTaskCardGroupData::getUserId, (Object)user.getUserId())).eq(CustomTaskCardGroupData::getTenantId, (Object)user.getTenantId())).eq(CustomTaskCardGroupData::getPageCode, (Object)oriPageCode)).orderByDesc(CustomTaskCardGroupData::getCheckTime)).last("LIMIT 1"));
            if (cardGroupData != null) {
                String memoryConfig = cardGroupData.getMemoryConfig();
                if (JSONUtil.isTypeJSONObject((String)memoryConfig)) {
                    result.put("effective", JSONUtil.parseObj((String)memoryConfig));
                } else if (oriPageCode.equals("task")) {
                    JSONObject jsonObject1 = new JSONObject();
                    jsonObject1.putIfAbsent((Object)"model", (Object)"normal");
                    cn.hutool.json.JSONArray value = new cn.hutool.json.JSONArray();
                    JSONObject e = new JSONObject();
                    value.add((Object)e);
                    e.putIfAbsent((Object)"code", (Object)cardGroupData.getGroupKey());
                    e.putIfAbsent((Object)"name", (Object)cardGroupData.getGroupName());
                    e.putIfAbsent((Object)"sort", (Object)"asc");
                    jsonObject1.putIfAbsent((Object)"normalValue", (Object)value);
                    result.put("effective", jsonObject1);
                } else {
                    result.put("effective", Collections.emptyMap());
                }
            } else {
                result.put("effective", Collections.emptyMap());
            }
        }
        catch (Exception e) {
            log.error("custom group record data parse error,", (Throwable)e);
        }
        return ResponseEntityWrapper.wrapperOk(result);
    }

    private List<JSONObject> convertCondition(Map<String, Object> result, Set<String> removeKey, cn.hutool.json.JSONArray defaultCondition) {
        if (CollectionUtils.isNotEmpty((Collection)defaultCondition)) {
            List<JSONObject> normalList = defaultCondition.stream().map(e -> new JSONObject((Object)JSONUtil.toJsonStr((Object)e))).filter(e -> "true".equals(e.getStr((Object)"enable"))).collect(Collectors.toList());
            normalList.forEach(o -> {
                o.putIfAbsent((Object)"normal", (Object)true);
                if ("groupByProjectTime".equals(o.getStr((Object)"aliasCode"))) {
                    cn.hutool.json.JSONArray pointInTime = o.getJSONArray((Object)"pointInTime");
                    cn.hutool.json.JSONArray dimensionality = o.getJSONArray((Object)"dimensionality");
                    JSONObject jsonObject1 = new JSONObject();
                    jsonObject1.putIfAbsent((Object)"time", (Object)pointInTime);
                    jsonObject1.putIfAbsent((Object)"date", (Object)dimensionality);
                    o.putIfAbsent((Object)"configs", (Object)jsonObject1);
                }
            });
            List<JSONObject> objects = normalList.stream().filter(e -> !removeKey.contains(e.getStr((Object)"aliasCode"))).map(o -> {
                JSONObject object = new JSONObject();
                String aliasCode = o.getStr((Object)"aliasCode");
                object.putIfAbsent((Object)"code", (Object)aliasCode);
                String aliasName = o.getStr((Object)"aliasName");
                object.putIfAbsent((Object)"name", (Object)aliasName);
                String sourceType = o.getStr((Object)"sourceType");
                object.putIfAbsent((Object)"type", (Object)sourceType);
                Boolean defaultGroup = o.getBool((Object)"defaultGroup");
                object.putIfAbsent((Object)"defaultEffective", (Object)defaultGroup);
                String sort = o.getStr((Object)"sort");
                object.putIfAbsent((Object)"sort", (Object)sort);
                JSONObject configs = o.getJSONObject((Object)"configs");
                if (configs != null) {
                    object.putIfAbsent((Object)"configs", (Object)configs);
                }
                return object;
            }).collect(Collectors.toList());
            return objects;
        }
        return Collections.emptyList();
    }

    @PostMapping(value={"groupRecord"})
    public ResponseEntity<?> groupRecord(@RequestBody JSONObject jsonObject, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        String pageCode = jsonObject.getStr((Object)"pageCode");
        CustomTaskCardGroupData customTaskCardGroupData = (CustomTaskCardGroupData)this.taskCardGroupService.getBaseMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomTaskCardGroupData::getUserId, (Object)user.getUserId())).eq(CustomTaskCardGroupData::getPageCode, (Object)pageCode)).eq(CustomTaskCardGroupData::getTenantId, (Object)user.getTenantId())).orderByDesc(CustomTaskCardGroupData::getCheckTime)).last("LIMIT 1"));
        if (customTaskCardGroupData == null || customTaskCardGroupData.getPageCode() == null) {
            CustomTaskCardGroupData insertData = new CustomTaskCardGroupData();
            insertData.setCheckTime(LocalDateTime.now());
            insertData.setUserId(user.getUserId());
            insertData.setTenantId(user.getTenantId());
            insertData.setPageCode(pageCode);
            insertData.setMemoryConfig(JSONUtil.toJsonStr((JSON)jsonObject.getJSONObject((Object)"data"), (int)0));
            this.taskCardGroupService.save((Object)insertData);
        } else {
            this.taskCardGroupService.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CustomTaskCardGroupData::getUserId, (Object)user.getUserId())).eq(CustomTaskCardGroupData::getTenantId, (Object)user.getTenantId())).eq(CustomTaskCardGroupData::getPageCode, (Object)pageCode)).set(CustomTaskCardGroupData::getMemoryConfig, (Object)JSONUtil.toJsonStr((JSON)jsonObject.getJSONObject((Object)"data"), (int)0))).set(CustomTaskCardGroupData::getCheckTime, (Object)LocalDateTime.now()));
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/getSystemMenu"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> getSystemMenu() {
        return ResponseEntityWrapper.wrapperOk((Object)this.menuService.getAllSystemMenus());
    }

    @GetMapping(value={"/v1/getAuthorityMenu"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> getAuthorityMenuOld(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.menuService.getAuthorityMenu(user));
    }

    @PostMapping(value={"/getAuthorityMenu"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> getAuthorityMenu(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody List<MenuAuthorityReq> menuList) {
        return ResponseEntityWrapper.wrapperOk((Object)this.menuService.getAuthorityMenu(user, menuList));
    }
}

