/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.presentation.server.web.trial;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.request.trial.userScene.TrailUserSceneBindReq;
import com.digiwin.athena.base.application.meta.request.trial.userScene.TrialUserSceneReq;
import com.digiwin.athena.base.application.meta.request.trial.userScene.TrialUserSceneResp;
import com.digiwin.athena.base.application.service.trial.TrialUserSceneService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/trial/userScene"})
public class TrialUserSceneController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrialUserSceneController.class);
    private final TrialUserSceneService trialUserSceneService;

    public TrialUserSceneController(TrialUserSceneService trialUserSceneService) {
        this.trialUserSceneService = trialUserSceneService;
    }

    @PostMapping(value={"/modify"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> modify(@RequestBody TrialUserSceneReq req) {
        int result = this.trialUserSceneService.modify(req);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/delete/{id}"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> delete(@PathVariable(value="id") long id) {
        int result = this.trialUserSceneService.delete(Long.valueOf(id));
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @PostMapping(value={"/bindScenes"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> bindScenes(@RequestBody TrailUserSceneBindReq req) {
        this.trialUserSceneService.bindScenes(req);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/queryWithScenes"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> queryWithScenes(@RequestParam(value="userId") String userId, @RequestParam(value="tenantId") String tenantId, @RequestParam(value="appCode") String appCode) {
        TrailUserSceneBindReq req = new TrailUserSceneBindReq();
        req.setUserId(userId);
        req.setTenantId(tenantId);
        req.setAppCode(appCode);
        TrialUserSceneResp resp = this.trialUserSceneService.listWithScenes(req);
        return ResponseEntityWrapper.wrapperOk((Object)resp);
    }

    @GetMapping(value={"/deleteWithUser"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> deleteWithUser(@RequestParam(value="userId") String userId, @RequestParam(value="sceneId") Long sceneId) {
        int result = this.trialUserSceneService.deleteWithUser(userId, sceneId);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }
}

