/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.sdk.aam.application.service;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.base.sdk.aam.application.meta.converter.AamSdkConverter;
import com.digiwin.athena.base.sdk.aam.application.meta.request.QueryAttachmentReqDTO;
import com.digiwin.athena.base.sdk.aam.application.meta.response.AttachmentRespDTO;
import com.digiwin.athena.base.sdk.aam.application.service.QueryAttachmentService;
import com.digiwin.athena.base.sdk.aam.infrastructure.mapper.QueryAttachmentMapper;
import com.digiwin.athena.base.sdk.aam.infrastructure.meta.po.AttachmentEntity;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryAttachmentServiceImpl
implements QueryAttachmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryAttachmentServiceImpl.class);
    @Autowired(required=false)
    private QueryAttachmentMapper queryAttachmentMapper;

    private QueryAttachmentMapper getAttachmentMapper() {
        if (null != this.queryAttachmentMapper) {
            return this.queryAttachmentMapper;
        }
        throw BusinessException.create((String)"attachment\u6570\u636e\u6e90\u521d\u59cb\u5316\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e.");
    }

    @Override
    public List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(String tenantId, String taskId, String projectId, List<String> categories, List<String> rowDataKeyList) {
        String tmpTenantId = tenantId;
        if (StringUtils.isBlank((CharSequence)tmpTenantId)) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            tmpTenantId = authoredUser.getTenantId();
        }
        String tmpTaskId = StringUtils.isNotBlank((CharSequence)taskId) ? taskId : null;
        String tmpProjectId = StringUtils.isNotBlank((CharSequence)projectId) ? projectId : null;
        log.info("queryByTaskIdAndRowDataKeyList params: tenantId: {}, taskId: {}, projectId: {}, categories: {}, rowDataKeyList: {}", new Object[]{tmpTenantId, tmpTaskId, tmpProjectId, categories, rowDataKeyList});
        List<AttachmentEntity> attachmentEntities = this.getAttachmentMapper().queryByTaskIdAndRowDataKeyList(tmpTenantId, tmpTaskId, tmpProjectId, categories, rowDataKeyList);
        if (CollectionUtils.isEmpty(attachmentEntities)) {
            return Collections.emptyList();
        }
        return attachmentEntities.stream().map(AamSdkConverter.INTENSIVE::toAttachmentRespDTO).collect(Collectors.toList());
    }

    @Override
    public List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(QueryAttachmentReqDTO reqDTO) {
        return this.queryByTaskIdAndRowDataKeyList(reqDTO.getTenantId(), reqDTO.getTaskId(), reqDTO.getProjectId(), reqDTO.getCategoryList(), reqDTO.getRowDataKeyList());
    }
}

