package com.digiwin.athena.base.sdk.aam.application.service;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.base.sdk.aam.application.meta.converter.AamSdkConverter;
import com.digiwin.athena.base.sdk.aam.application.meta.request.QueryAttachmentReqDTO;
import com.digiwin.athena.base.sdk.aam.application.meta.response.AttachmentRespDTO;
import com.digiwin.athena.base.sdk.aam.infrastructure.mapper.QueryAttachmentMapper;
import com.digiwin.athena.base.sdk.aam.infrastructure.meta.po.AttachmentEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class QueryAttachmentServiceImpl implements QueryAttachmentService {
    @Autowired(required = false)
    private QueryAttachmentMapper queryAttachmentMapper;

    private QueryAttachmentMapper getAttachmentMapper() {
        if (null != queryAttachmentMapper) {
            return queryAttachmentMapper;
        }
        throw BusinessException.create("attachment数据源初始化有问题，请检查配置.");
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(String tenantId, String taskId, String projectId, List<String> categories, List<String> rowDataKeyList) {
        String tmpTenantId = tenantId;
        if (StringUtils.isBlank(tmpTenantId)) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            tmpTenantId = authoredUser.getTenantId();
        }

        String tmpTaskId = StringUtils.isNotBlank(taskId) ? taskId : null;
        String tmpProjectId = StringUtils.isNotBlank(projectId) ? projectId : null;

        log.info("queryByTaskIdAndRowDataKeyList params: tenantId: {}, taskId: {}, projectId: {}, categories: {}, rowDataKeyList: {}", tmpTenantId, tmpTaskId, tmpProjectId, categories, rowDataKeyList);
        List<AttachmentEntity> attachmentEntities = getAttachmentMapper().queryByTaskIdAndRowDataKeyList(tmpTenantId, tmpTaskId, tmpProjectId, categories, rowDataKeyList);
        if (CollectionUtils.isEmpty(attachmentEntities)) {
            return Collections.emptyList();
        }

        return attachmentEntities.stream().map(AamSdkConverter.INTENSIVE::toAttachmentRespDTO).collect(Collectors.toList());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(QueryAttachmentReqDTO reqDTO) {
        return this.queryByTaskIdAndRowDataKeyList(reqDTO.getTenantId(), reqDTO.getTaskId(), reqDTO.getProjectId(), reqDTO.getCategoryList(), reqDTO.getRowDataKeyList());
    }

}
