package com.digiwin.athena.base.sdk.aam.infrastructure.meta.po;

import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 附件数据库实体类
 *
 * @author majfa
 * @date 2020.11.14
 * @since [迭代10，附件]
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors(chain = true)
@TableName("t_attachment")
public class AttachmentEntity extends BaseEntity<AttachmentEntity> {
    /**
     * 文档中心生成的附件id
     */
    private String id;

    /**
     * 附件名称
     */
    private String name;

    /**
     * table行数据唯一标示key
     */
    private String rowDataKey;

    /**
     * 附件目录名称id
     */
    private String categoryId;

    /**
     * 附件目录名
     */
    private String category;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 活动id
     */
    private String taskId;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 附件大小
     */
    private Integer size;

    /**
     * 上传者用户id
     */
    private String uploadUserId;

    /**
     * 上传者用户名称
     */
    private String uploadUserName;

    /**
     * 附件描述
     */
    private String description;

    /**
     * zip包解压密码
     */
    private String defence;
}
