package com.digiwin.athena.base.sdk.aam.application.service;

import com.digiwin.athena.base.sdk.aam.application.meta.request.QueryAttachmentReqDTO;
import com.digiwin.athena.base.sdk.aam.application.meta.response.AttachmentRespDTO;

import java.util.List;

public interface QueryAttachmentService {
    /**
     * 根据活动id、租户id和行数据标识列表查询
     *
     * @param tenantId       租户id
     * @param taskId         tmActivityId
     * @param projectId      项目id
     * @param categories     附件目录列表
     * @param rowDataKeyList 行数据标识列表
     * @return 附件信息
     */
    List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(String tenantId, String taskId, String projectId, List<String> categories, List<String> rowDataKeyList);

    /**
     * 根据活动id、租户id和行数据标识列表查询
     *
     * @param queryAttachmentReqDTO
     */
    List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(QueryAttachmentReqDTO queryAttachmentReqDTO);

}
