package com.digiwin.athena.base.sdk.audc.application.service.userdefined;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.bo.userdefined.mongo.UserDefinedFieldsBO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserGridPO;
import org.springframework.data.mongodb.core.MongoTemplate;

import java.util.List;

public interface QueryUserDefinedService {
    public MongoTemplate getUserDefinedMongoTemplate();


    // /api/audc/v1/userdefined/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}
    UserDefinedPO getFieldSeqList(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema, String pageUniqueCode);


    // /api/audc/v1/userdefined/batch/fieldlist
    List<UserDefinedFieldsBO> getFieldSeqList(List<String> tmActivityIdList);

    // /api/audc/v1/userdefined/orderconditions/fields/{pageCode}/{tmProjectId}/{tmActivityId}
    UserDefinedPO getOrderConditionsByUser(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema, String pageUniqueCode);

    /**
     * 根据当前用户信息，获取数据排序条件集合
     *
     * @param user
     * @param pageCode
     * @param tmProjectId
     * @param tmActivityId
     * @param tableSchema
     * @return
     */
    // /orderconditions/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}
    List<UserDefinedPO> getOrderConditionsFields(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema);

    // /api/audc/v1/userdefined/searchConditions/{tmActivityId}/{pageCode}/{tableSchema}
    List<UserDefinedPO> getSearchConditions(AuthoredUser user, UserDefinedPO userDefined);

    // gridItem/{activityId}/{pageCode}
    UserGridPO getGridItems(UserGridPO userGridDTO);

}
