package com.digiwin.athena.base.sdk.audc.infrastructure.mongo;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.bo.userdefined.mongo.UserDefinedFieldsBO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedMetadataPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedTagResponsePO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserGridPO;
import com.google.common.collect.Lists;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Repository
public class QueryUserDefinedMapper {
    @Autowired(required = false)
    @Qualifier("userdefinedMongoTemplate")
    private MongoTemplate userdefinedMongoTemplate;

    //字段排序
    protected static String PURPOSE_FIELDSEQBYUSER = "FieldSeqByUser";

    //数据排序条件
    protected static String PURPOSE_SEARCH_CONDITIONS = "SearchConditions";

    protected static String COLLECTION_NAME = "user_defined_center";

    protected static String GRID_COLLECTION_NAME = "user_grid_items";

    public MongoTemplate getUserdefinedMongoTemplate() {
        if (null != userdefinedMongoTemplate) {
            return userdefinedMongoTemplate;
        }
        throw BusinessException.create("请检查userDefined数据源配置是否正确.");
    }

    /**
     * 获取用户自定义栏位属性
     *
     * @param userDefined
     * @return
     */
    public UserDefinedPO getFieldSeqList(UserDefinedPO userDefined) {
        Query query = getQuery(userDefined);
        if (StringUtils.isNotEmpty(userDefined.getTableSchema())) {
            query = getQueryInTable(userDefined);
        }
        List<UserDefinedPO> list = this.getUserdefinedMongoTemplate().find(query, UserDefinedPO.class, COLLECTION_NAME);
        if (CollectionUtils.isNotEmpty(list) && list.size() > 0) {
            UserDefinedPO userDefinedNew = list.get(0);
            if (CollectionUtils.isNotEmpty(userDefinedNew.getMetadataTags())) {
                userDefinedNew.getMetadataTags().stream().forEach(tag -> tag.setTableSchema(userDefinedNew.getTableSchema()));
            }
            if (PURPOSE_FIELDSEQBYUSER.equals(userDefined.getPurpose())) {
                if (list.size() > 1) {
                    for (int i = 1; i < list.size(); i++) {
                        if (CollectionUtils.isNotEmpty(list.get(i).getMetadataTags())) {
                            int finalI = i;
                            list.get(i).getMetadataTags().stream().forEach(tag -> tag.setTableSchema(list.get(finalI).getTableSchema()));
                        }
                        userDefinedNew.getMetadataTags().addAll(list.get(i).getMetadataTags());
                    }
                }
            } else {
                if (StringUtils.isNotEmpty(userDefinedNew.getTableSchema())) {
                    JSONObject settingWithTable = new JSONObject();
                    settingWithTable.put(userDefinedNew.getTableSchema(), userDefinedNew.getSettings());
                    userDefinedNew.setSettings(settingWithTable);
                    if (list.size() > 1) {
                        for (int i = 1; i < list.size(); i++) {
                            UserDefinedPO oneUserDefined = list.get(i);
                            if (StringUtils.isNotEmpty(oneUserDefined.getTableSchema())) {
                                settingWithTable.put(oneUserDefined.getTableSchema(), oneUserDefined.getSettings());
                            }
                        }
                    }
                } else {//兼容没有tableSchema情况
                    if (list.size() > 1) {
                        JSONArray options = userDefinedNew.getSettings().getJSONObject("order").getJSONArray("options");
                        for (int i = 1; i < list.size(); i++) {
                            options.addAll(list.get(i).getSettings().getJSONObject("order").getJSONArray("options"));
                        }
                    }
                }
            }
            return userDefinedNew;
        }
        return new UserDefinedPO();
    }

    /**
     * 组装查询条件
     * 获取当前用户、当前租户、当前任务中所有表格栏位属性
     *
     * @param userDefined
     * @return
     */
    protected Query getQuery(UserDefinedPO userDefined) {
        Query query = new Query();
        query.addCriteria(Criteria.where("purpose").is(userDefined.getPurpose()));
        query.addCriteria(Criteria.where("userId").is(userDefined.getUserId()));
        query.addCriteria(Criteria.where("tenantId").is(userDefined.getTenantId()));
        query.addCriteria(Criteria.where("pageCode").is(userDefined.getPageCode()));
        query.addCriteria(Criteria.where("tmProjectId").is(userDefined.getTmProjectId()));
        query.addCriteria(Criteria.where("tmActivityId").is(userDefined.getTmActivityId()));
        if (StringUtils.isNotBlank(userDefined.getPageUniqueCode())) {
            query.addCriteria(Criteria.where("pageUniqueCode").is(userDefined.getPageUniqueCode()));
        }
        return query;
    }

    /**
     * 组装查询条件--new
     * 获取某一个指定表格的栏位属性
     *
     * @param userDefined
     * @return
     */
    protected Query getQueryInTable(UserDefinedPO userDefined) {
        Query query = new Query();
        query.addCriteria(Criteria.where("purpose").is(userDefined.getPurpose()));
        query.addCriteria(Criteria.where("tableSchema").is(userDefined.getTableSchema()));
        query.addCriteria(Criteria.where("userId").is(userDefined.getUserId()));
        query.addCriteria(Criteria.where("tenantId").is(userDefined.getTenantId()));
        query.addCriteria(Criteria.where("pageCode").is(userDefined.getPageCode()));
        query.addCriteria(Criteria.where("tmProjectId").is(userDefined.getTmProjectId()));
        query.addCriteria(Criteria.where("tmActivityId").is(userDefined.getTmActivityId()));
        return query;
    }

    public List<UserDefinedFieldsBO> getFieldSeqList(List<String> tmActivityIdList) {
        Criteria criteria = Criteria.where("tmActivityId").in(tmActivityIdList);
        Query query = Query.query(criteria);
        List<UserDefinedPO> UserDefinedPOList = this.getUserdefinedMongoTemplate().find(query, UserDefinedPO.class, COLLECTION_NAME);
        List<UserDefinedFieldsBO> resultList = Lists.newArrayList();
        Map<String, List<UserDefinedPO>> taskIdMap = UserDefinedPOList.stream().collect(Collectors.groupingBy(UserDefinedPO::getTmActivityId));
        for (Map.Entry<String, List<UserDefinedPO>> entry : taskIdMap.entrySet()) {
            String activityId = entry.getKey();
            List<UserDefinedPO> userDefineList = entry.getValue();
            // 字段去重
            List<List<String>> distinctFieldList = Lists.newArrayList();
            userDefineList.forEach(userDefined -> {
                List<UserDefinedMetadataPO> metadataTags = userDefined.getMetadataTags();
                List<String> fields = Optional.ofNullable(metadataTags).orElse(Lists.newArrayList()).stream()
                        .map(UserDefinedMetadataPO::getResourceContent)
                        .map(UserDefinedTagResponsePO::getResponse)
                        .filter(fieldName -> fieldName.contains("."))
                        .map(fieldName -> fieldName.substring(fieldName.lastIndexOf(".") + 1))
                        .distinct()
                        .collect(Collectors.toList());
                if (!distinctFieldList.contains(fields)) {
                    distinctFieldList.add(fields);
                }
            });
            UserDefinedFieldsBO userDefinedFields = UserDefinedFieldsBO.builder().activityId(activityId).userDefinedFieldList(distinctFieldList).build();
            resultList.add(userDefinedFields);
        }
        return resultList;
    }

    /**
     * 获取用户自定义栏位属性
     *
     * @param userDefined
     * @return
     */
    public List<UserDefinedPO> getFieldSeqs(UserDefinedPO userDefined) {
        Query query = getQuery(userDefined);
        if (StringUtils.isNotEmpty(userDefined.getTableSchema())) {
            query = getQueryInTable(userDefined);
        }
        List<UserDefinedPO> lists = Lists.newArrayList();
        List<UserDefinedPO> list = this.getUserdefinedMongoTemplate().find(query, UserDefinedPO.class, COLLECTION_NAME);
        if (CollectionUtils.isNotEmpty(list)) {
            for (UserDefinedPO userDefinedNew : list) {
                if (CollectionUtils.isNotEmpty(userDefinedNew.getMetadataTags())) {
                    userDefinedNew.getMetadataTags().stream().forEach(tag -> tag.setTableSchema(userDefinedNew.getTableSchema()));
                }
                if (PURPOSE_FIELDSEQBYUSER.equals(userDefined.getPurpose())) {
                    if (list.size() > 1) {
                        for (int i = 1; i < list.size(); i++) {
                            if (CollectionUtils.isNotEmpty(list.get(i).getMetadataTags())) {
                                int finalI = i;
                                list.get(i).getMetadataTags().stream().forEach(tag -> tag.setTableSchema(list.get(finalI).getTableSchema()));
                            }
                            userDefinedNew.getMetadataTags().addAll(list.get(i).getMetadataTags());
                        }
                    }
                } else {
                    if (StringUtils.isNotEmpty(userDefinedNew.getTableSchema())) {
                        JSONObject settingWithTable = new JSONObject();
                        settingWithTable.put(userDefinedNew.getTableSchema(), userDefinedNew.getSettings());
                        userDefinedNew.setSettings(settingWithTable);
                        if (list.size() > 1) {
                            for (int i = 1; i < list.size(); i++) {
                                UserDefinedPO oneUserDefined = list.get(i);
                                if (StringUtils.isNotEmpty(oneUserDefined.getTableSchema())) {
                                    settingWithTable.put(oneUserDefined.getTableSchema(), oneUserDefined.getSettings());
                                }
                            }
                        }
                    } else {//兼容没有tableSchema情况
                        if (list.size() > 1) {
                            JSONArray options = userDefinedNew.getSettings().getJSONObject("order").getJSONArray("options");
                            for (int i = 1; i < list.size(); i++) {
                                options.addAll(list.get(i).getSettings().getJSONObject("order").getJSONArray("options"));
                            }
                        }
                    }
                }
                lists.add(userDefinedNew);
            }
        }
        return lists;
    }

    public List<UserDefinedPO> getSearchConditions(UserDefinedPO userDefined) {
        userDefined.setPurpose(PURPOSE_SEARCH_CONDITIONS);
        Query query = getSearchConditionsQuery(userDefined);
        String name = userDefined.getName();
        if (StringUtils.isNotBlank(name)) {
            query.addCriteria(Criteria.where("name").is(name));
        }
        return this.getUserdefinedMongoTemplate().find(query, UserDefinedPO.class, COLLECTION_NAME);
    }

    /**
     * 构造高级查询常用条件查询条件
     *
     * @param userDefined
     * @return
     */
    protected Query getSearchConditionsQuery(UserDefinedPO userDefined) {
        Query query = new Query();
        query.addCriteria(Criteria.where("purpose").is(userDefined.getPurpose()));
        query.addCriteria(Criteria.where("tableSchema").is(userDefined.getTableSchema()));
        query.addCriteria(Criteria.where("userId").is(userDefined.getUserId()));
        query.addCriteria(Criteria.where("tenantId").is(userDefined.getTenantId()));
        query.addCriteria(Criteria.where("pageCode").is(userDefined.getPageCode()));
        query.addCriteria(Criteria.where("tmActivityId").is(userDefined.getTmActivityId()));
        if (StringUtils.isNotBlank(userDefined.getPageUniqueCode())) {
            query.addCriteria(Criteria.where("pageUniqueCode").is(userDefined.getPageUniqueCode()));
        }
        return query;
    }

    public UserGridPO getUserGrid(UserGridPO userGridDTO) {
        Query query = new Query();
        query.addCriteria(Criteria.where("code").is(userGridDTO.getCode()));
        query.addCriteria(Criteria.where("tenantId").is(userGridDTO.getTenantId()));
        query.addCriteria(Criteria.where("userId").is(userGridDTO.getUserId()));
        query.addCriteria(Criteria.where("pageCode").is(userGridDTO.getPageCode()));
        List<UserGridPO> list = this.getUserdefinedMongoTemplate().find(query, UserGridPO.class, GRID_COLLECTION_NAME);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return new UserGridPO();
    }
}
