/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.sdk.audc.application.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.handler.BaseEntityMetaObjectHandler;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.injector.BatchInsertSqlInjector;
import javax.sql.DataSource;
import org.apache.ibatis.logging.log4j2.Log4j2Impl;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@ConditionalOnProperty(name={"spring.datasource.druid.audc.enable"}, havingValue="true")
@Configuration
@MapperScan(value={"com.digiwin.athena.base.sdk.audc.infrastructure.mapper"}, sqlSessionFactoryRef="audcSqlSessionFactory")
@EnableTransactionManagement
public class AudcSDKDataSourceConfig {
    private static final String DATASOURCE_NAME = "audcSdkDataSource";
    private static final String BUSINESS_DATASOURCE_PREFIX = "spring.datasource.druid.audc";
    public static final String AUDC_SDK_SQL_SESSION_FACTORY_NAME = "audcSqlSessionFactory";
    public static final String AUDC_SDK_DATASOURCE_TRANSACTION_MANAGER_BUSINESS = "audcSDKDataSourceTransactionManager";

    @Bean(name={"audcSdkDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.druid.audc")
    public DruidDataSource audcDruidDataSource() {
        System.err.println("\u521d\u59cb\u5316AudcSDKDataSourceConfig\u4e2d\u3002\u3002\u3002");
        return new DruidDataSource();
    }

    @Bean(name={"audcSqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactory(@Qualifier(value="audcSdkDataSource") DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapper/sdk/audc/*.xml"));
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setCacheEnabled(false);
        configuration.setLogImpl(Log4j2Impl.class);
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        bean.setConfiguration(configuration);
        GlobalConfig globalConfig = GlobalConfigUtils.defaults();
        globalConfig.setBanner(false);
        globalConfig.setSqlInjector((ISqlInjector)new BatchInsertSqlInjector());
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new BaseEntityMetaObjectHandler());
        bean.setGlobalConfig(globalConfig);
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.MYSQL));
        bean.setPlugins(new Interceptor[]{interceptor});
        bean.setPlugins(new Interceptor[0]);
        return bean.getObject();
    }

    @Bean(name={"audcSDKDataSourceTransactionManager"})
    public DataSourceTransactionManager transactionManager(@Qualifier(value="audcSdkDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}

