package com.digiwin.athena.base.sdk.audc.application.util;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.context.i18n.LocaleContextHolder;

import java.util.List;
import java.util.Map;

/**
 * 公共的工具类
 */
public final class LocaleUtils {
    private LocaleUtils() {
    }

    /**
     * 集合国际化 如{
     * "title": "内部",
     * "value": "1",
     * "lang": {
     * "title": {
     * "en_US": "internal",
     * "zh_TW": "內部"
     * }
     * }
     * }
     *
     * @param mapList
     */
    public static void valueLocale(List<Map<String, Object>> mapList) {
        if (!CollectionUtils.isEmpty(mapList)) {
            String s = LocaleContextHolder.getLocale().toString();
            for (Map<String, Object> map : mapList) {
                Map<String, Map<String, Object>> langMap = (Map<String, Map<String, Object>>) MapUtils.getMap(map, "lang");
                langMap.forEach((k, v) -> {
                    // 当前map是否包含国际化对应的字段
                    if (map.containsKey(k)) {
                        // 国际化对应的值
                        Object o = v.get(s);
                        if (o != null) {
                            map.put(k, o);
                        }
                    }
                });
            }
        }
    }

}
