package com.digiwin.athena.base.sdk.common.application.annotation;


import com.digiwin.athena.base.sdk.common.application.validator.ElementNotBlankConstraint;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Documented
@Target({METHOD, FIELD, PARAMETER})
@Retention(RUNTIME)
@Constraint(validatedBy = {ElementNotBlankConstraint.class})
public @interface ElementNotBlank {
    String message() default " value must not be blank.";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
