package com.digiwin.athena.base.sdk.common.application.properties;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public abstract class PropertyExistCondition implements Condition {
    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {

        return context.getEnvironment().containsProperty(getCheckedPropertyName()); // 检查配置项是否存在
    }

    protected abstract String getCheckedPropertyName();
}
