package com.digiwin.athena.atdm.datasource.domain;


import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @description: 元数字段描述
 * @author: wangminga
 * @create: 2020-05-14 11:14
 **/
@Getter
@Setter
public class MetadataField implements Serializable {

    /**
     * 字段编码
     */
    private String name;

    /**
     * 是否必填
     */
    private boolean required;

    /**
     * 字段描述
     */
    private String description;

    /**
     * 字段备注
     */
    private String remark;

    /**
     * 是否主键
     */
    private String dataKey;

    private Boolean businessKey;

    /**
     * 数据类型（是否是子节点）
     */
    private String dataType;

    private Map precision;

    private Object objectData;

    /**
     * 可排序字段
     */
    private Boolean canSort;

    /**
     * 是否可筛选
     */
    private Boolean canFilter;

    /**
     * 字段类型
     */
    private String fieldType;

    /**
     * 是否可以编辑
     */
    private boolean canEdit;

    /**
     * 字段的标签--原则上不存在相同的标签，设计器阶段应该过滤掉
     */
    private List<TagDefinition> tagDefinitions;

    /**
     * 拥有的字段
     */
    private List<MetadataField> subFields;

    private List<MetadataField> exportTableFields;

    /**
     * 是否多笔数据
     */
    private Boolean array;


    /**
     * UIBOT-属性 来源API
     */
    private String sourceApi;

    /**
     * UIBOT-属性
     */
    private boolean checkItem;

    /**
     * UIBOT-属性
     */
    private String clientAgent;

    /**
     * UIBOT-属性 UIBOT模拟出来
     */
    private String uiBot;

    private List<Map<String, Object>> rules;

    /**
     * 如果字段有下拉列表，则存放下拉列表对应的key
     * 对应元数据中的  enum_key
     */
    private String enumKey;
}
