package com.digiwin.athena.atdm.datasource.dto;

import com.digiwin.athena.atdm.datasource.domain.CheckItem;
import com.digiwin.athena.atdm.datasource.domain.CountItem;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 活动的定义
 */
@Data
public class TaskDefineDTO implements Serializable {

    /**
     * 区域块的标题
     */
    private String title;
    private String subTitle;
    private String description;
    private String subDescription;
    private String taskName;
    private String backlogId;

    /**
     * 是否紧急
     */
    private Boolean isEmergency;

    /**
     * 显示的按钮的标题
     */
    private String queryTitle;
    /**
     * 数据行数
     */
    private Integer rowSize;

    /**
     * 模板那边使用到
     */
    private String type;
    /**
     * 是否支持多选
     */
    private Boolean multipleSelect;

    private Boolean multipleSelectMerge;
    /**
     * 多页面默认显示哪部分
     */
    private boolean defaultShow;

//    /**
//     * 是否显示  目前没用 迭代13 将会去掉
//     */
//    @Deprecated
//    private Boolean unDisplayed;

//
//    /**
//     * 查询的数据源
//     */
//    private DataSourceSetDTO dataSourceSet;

//    /**
//     * 如果有参数类型为ACTIVE_ROW，则需要前端传入参数值，由后端查询时替换
//     */
//    private Map<String,Object> parameter;

//    /**
//     * 标签增强
//     */
//    private List<DataTag> dataTags;
//    /**
//     * 查询tag固定后缀
//     */
//    private String queryTagSuffix;

    /**
     * action 检查项目
     */
    private  List<CheckItem>  checkItems;

    /**
     * action 检查项目
     */
    private CountItem countItems;


    /**
     * 提交按钮 ACTION
     */
    private List<SubmitAction> submitActions;

//    /**
//     * 任务是否已经完成
//     */
//    private Boolean  finished;
//    /**
//     * 任务完成是的标题
//     */
//    private String finishedTitle;
//
//    /**
//     * table 脚本二次过滤
//     */
//    private List<FilterDTO> scriptFilters;

//
//    /**
//     * 分组 支持 treeTable 的样式
//     */
//    private JSONObject settings;

//    /**
//     * 签核任务的发起任务名称
//     */
//    private String startApproveActivityName;

//    /**
//     * 执行上下文
//     */
//    private ExecuteContext executeContext;

    /**
     * dataFilter中定义的限制返回结果行数
     */
    private Integer limit;

//    /**
//     * 显示获总条数类型
//     */
//    private String rowSizeType;


}
