package com.digiwin.athena.atdm.esp.invoker;

import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;

public interface EspInvoker {
    /**
     * 调用ESP
     *
     * @param sync         是否同步
     * @param requestModel 请求参数
     * @return ResponseModel
     */
    default ResponseModel invokeRest(boolean sync, RequestModel requestModel) throws Exception {
        return sync ? invokeRestSync(requestModel) : invokeRestFasync(requestModel);
    }

    /**
     * 同步调用ESP
     *
     * @param requestModel 请求参数
     * @return ResponseModel
     */
    ResponseModel invokeRestSync(RequestModel requestModel) throws Exception;

    /**
     * 全异步调用ESP
     *
     * @param requestModel 请求参数
     * @return ResponseModel
     */
    ResponseModel invokeRestFasync(RequestModel requestModel) throws Exception;
}
