package com.digiwin.athena.atdm.recycle;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atdm.recycle.dto.RecycleRecordStateChangeDTO;

import java.util.List;
import java.util.Map;

public interface CommonRecycleService {

    /**
     * 当前租户下回收站中被删除作业的数量
     *
     * @return
     */
    int getRecycleCount(String tenantId);

    /**
     * 回收站列表
     *
     * @param tenantId
     * @return
     */
    List<Map<String, Object>> queryActivityList(String tenantId);

    /**
     * 当前作业被删除的文档列表
     *
     * @param tenantId
     * @param activityCode
     * @return
     */
    List queryActivityDataList(String tenantId, String activityCode);

    /**
     * 将删除的数据插入到回收站
     *
     * @param authoredUser 登录用户鉴权信息
     * @param activityCode 活动码
     * @param dataList     需要放入回收站的数据
     */
    void insertRecycle(AuthoredUser authoredUser, String activityCode, List<Map<String, Object>> dataList);

    /**
     * 从回收站批量删除数据
     *
     * @param dataList
     * @return
     */
    void deleteRecycle(AuthoredUser authoredUser, String activityCode, List<Map<String, Object>> dataList);

    /**
     * 清空回收站
     *
     * @return
     */
    void deleteAll(String tenantId);

    /**
     * 根据activityCode删除回收站数据
     *
     * @param authoredUser
     * @param tmActivityId
     */
    void deleteByActivityCode(AuthoredUser authoredUser, String tmActivityId);

    /**
     * 将记录标记为过期
     *
     * @param recycleRecordStateChangeDTO
     */
    void markExpired(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO);

    /**
     * 将记录标记为未过期
     *
     * @param recycleRecordStateChangeDTO
     */
    void markUnexpired(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO);

    /**
     * 将记录标记为已删除（硬删除）
     *
     * @param recycleRecordStateChangeDTO
     */
    void markDeleted(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO);
}
