package com.digiwin.athena.atdm.datasource.domain;


import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Action实体定义
 * @author zhujg
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Action implements Serializable {


    /**
     * action的显示标题
     */
    private String title;

    /**
     * action的id,themeMap中定义
     */
    private String actionId;

    /**
     * action的type，themeMap中定义
     */
    private String actionType;

    /**
     * 同步异步
     */
    private String invokeType;

    /**
     * action的类型，目前只有ESP(业务)和WF(工作流BPM)
     */
    private String  category;

    /**
     * 服务Id，包括服务真正执行的服务
     */
    private ActionServiceId serviceId;

    /**
     * 执行Action的参数,是多个的合并，执行的时候是分开执行
     */
    private Map<String,Object> paras;

    /**
    * 营运单元
    */
    private Map<String, Object> businessUnit;

    /**
     * 所有转换参数的定义
     */
    private List<ActionParameterMapping> actionParams;

    /**
     * 给前端使用的扩展字段
     */
    private Map<String,Object> extendedFields;

    /**
     * 是否需要压缩
     */
    private Boolean needCompress = false;

    /**
     * 是否增量地提交，如果不是增量，name提交的是全部数据
     */
    private Boolean enableCombinedPost = true;

    /**
     * esp api查询标识，默认为true
     */
    private Boolean queryData = true;

    public Action(String title, String actionId, String actionType, String invokeType, String category, ActionServiceId serviceId, Map<String, Object> paras, Map<String, Object> businessUnit, List<ActionParameterMapping> actionParams, Map<String, Object> extendedFields) {
        this.title = title;
        this.actionId = actionId;
        this.actionType = actionType;
        this.invokeType = invokeType;
        this.category = category;
        this.serviceId = serviceId;
        this.paras = paras;
        this.businessUnit = businessUnit;
        this.actionParams = actionParams;
        this.extendedFields = extendedFields;
    }



    /**
     * 转换ESP 服务真实使用的参数
     * @param realParameter
     * @return
     */
    public Map<String,Object>  initParas( Map<String,Object> realParameter){
        Map<String,Object> serviceParameter;
        if (UiBotConstants.ACTION_CATEGORY_ESP.equals(this.getCategory()) ) {
            serviceParameter = new HashMap<>();
            Map<String, Object> std_data = new HashMap<>();
            Map<String, Object> parameter = new HashMap<>();
            serviceParameter.put("std_data", std_data);
            std_data.put("parameter", parameter);
            parameter.put("enterprise_no", "");
            parameter.put("site_no", "");
            if (realParameter != null) {
                realParameter.forEach((itemKey, itemValue) -> {
                    if (!itemKey.startsWith("uiBot")) {
                        parameter.put(itemKey, itemValue);
                    }
                });
            }
        }
        else {
            throw BusinessException.create(ErrorCodeEnum.UNSUPPORTED_CATEGORY.getErrCode(), "目前支持ESP,WF2种ACTION_CATEGORY");
        }
        return serviceParameter;
    }


}
