package com.digiwin.athena.atdm.taskengine;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDataDto;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class CommonTaskEngineServiceImpl implements CommonTaskEngineService {

    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void execute(Action action) {
//        log.info("[执行任务引擎]：{}", JsonUtils.objectToString(action.getParas()));

        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        ActionServiceId serviceId = action.getServiceId();
        serviceId = serviceId == null ? ActionServiceId.empty() : serviceId;

        if (StringUtils.hasText(serviceId.getProxyToken())) {
            headerMap.add(GlobalConstant.IAM_USER_TOKEN, serviceId.getProxyToken());
            headerMap.add(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, serviceId.getProxyToken());
        }
        String serviceUri = envProperties.getTaskEngineUri() + serviceId.getServiceUri();
        String tenantId = serviceId.getTenant_id();

        LogDto logDto = new LogDto("执行任务引擎action开始，serviceUri：" + serviceUri, tenantId + LogConstant.TRACE_SEPARATOR + serviceUri);
        LogDataDto logDataDto = new LogDataDto(serviceId.getServiceUri(), "调用url", LogConstant.TYPE_LINK, LogConstant.LABEL_TASK_ENGINE);
        logDto.setData(Arrays.asList(logDataDto));
        log.info(logDto.toString());
        try {
            HttpEntity httpEntity = new HttpEntity<Map>(action.getParas(), headerMap);
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });
            responseEntity.getBody().getResponseWithException("");
            LogDto logDtoSuccess = new LogDto("执行任务引擎action成功，serviceUri：" + serviceUri, tenantId + LogConstant.TRACE_SEPARATOR + serviceUri);
            LogDataDto logDataDtoSuccess = new LogDataDto(serviceId.getServiceUri(), "调用url", LogConstant.TYPE_LINK, LogConstant.LABEL_TASK_ENGINE);
            logDtoSuccess.setData(Arrays.asList(logDataDtoSuccess));
            log.info(logDtoSuccess.toString());
//            if (responseEntity.getBody() != null) {
//                Map result = responseEntity.getBody();
//                if (!"200".equals(result.get("status").toString())) {
//                    throw BusinessException.create(String.format(messageUtils.getMessage("exception.taskEngine.error1"), result.get("errorMessage"), serviceUri, action.getParas()));
//                }
//            }


        } catch (Exception ex) {
            LogDto logDtoFail = new LogDto("执行任务引擎action失败，serviceUri：" + serviceUri, serviceId.getTenant_id() + LogConstant.TRACE_SEPARATOR + serviceUri);
            LogDataDto logDataDtoFail = new LogDataDto(serviceId.getServiceUri(), "调用url", LogConstant.TYPE_LINK, LogConstant.LABEL_TASK_ENGINE);
            logDtoFail.setData(Arrays.asList(logDataDtoFail));
            log.error(logDtoFail.toString());
            log.error("[执行任务引擎] serviceUri: {}, body: {}, error: ", serviceUri, JsonUtils.objectToString(action.getParas()), ex);
            throw ex;
//            throw BusinessException.create(String.format(messageUtils.getMessage("exception.taskEngine.error2"), serviceUri, action.getParas(), ex.getMessage()));
        }
    }

    @Override
    public Map<String, Object> startNewProject(String userId, String projectCode, Map<String, Object> eocMap, Map<String, Object> variables, List<Map<String, Object>> dispatchDataList) {
        String url = envProperties.getTaskEngineUri() + "api/project/create";

        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
//        httpHeaders.add("digi-dap-service-chain-info", UUID.randomUUID().toString());
        Map<String, Object> body = new HashMap<>();
        body.put("projectCode", projectCode);
        body.put("requesterId", userId);
        body.put("dispatchData", dispatchDataList);
        body.put("variables", variables);
        body.put("process_EOC", eocMap);

        log.error("[任务引擎发起新项目] body: {}", JsonUtils.objectToString(body));

        HttpEntity httpEntity = new HttpEntity<Map>(body, httpHeaders);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            return responseEntity.getBody().getResponseWithException("");
//            if (HttpStatus.SC_OK == responseEntity.getStatusCodeValue() && responseEntity.getBody().isOK()) {
//                return responseEntity.getBody().getResponse();
//            }
//
//            String errorMsg = String.format(messageUtils.getMessage("exception.taskEngine.launch.new.project"),
//                    responseEntity.getStatusCodeValue(), String.valueOf(responseEntity.getBody()));
//            throw BusinessException.create(errorMsg);
        } catch (Exception ex) {
            log.error("[任务引擎发起新项目] body: {}, error: ", JsonUtils.objectToString(body), ex);
            throw ex;
//            throw BusinessException.create(messageUtils.getMessage("exception.taskEngine.launch.new.project2") + ex.getMessage());
        }
    }
}
