/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.config;

import com.digiwin.athena.atdm.config.ThreadPoolMonitor;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jugg.agile.framework.core.util.concurrent.migration.JaTtlExecutors;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class ExecutorConfig {
    @Value(value="${async.executor.thread.core_pool_size}")
    private int corePoolSize;
    @Value(value="${async.executor.thread.max_pool_size}")
    private int maxPoolSize;
    @Value(value="${async.executor.thread.queue_capacity}")
    private int queueCapacity;
    @Value(value="${async.executor.thread.name.prefix}")
    private String namePrefix;

    @Bean(name={"asyncServiceExecutor"})
    public ExecutorService asyncServiceExecutor() {
        ThreadFactory normalThreadFactory = new ThreadFactoryBuilder().setNameFormat(this.namePrefix + "_%d").build();
        ThreadPoolMonitor executor = new ThreadPoolMonitor(this.corePoolSize, this.maxPoolSize, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.queueCapacity), this.queueCapacity, normalThreadFactory, this.namePrefix, new ThreadPoolExecutor.AbortPolicy());
        return JaTtlExecutors.getTtlExecutorService((ExecutorService)executor);
    }
}

