package com.digiwin.athena.atdm.datasource.domain;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 执行数据处理器
 * @author: wangminga
 * @create: 2020-09-03 15:01
 **/
@Data
public class DataSourceProcessor implements Serializable {

    private String type;

    private String serviceName;

    private Object paras;
    /**
     * 每个查询对应的任务数据
     */
    private TaskWithBacklogData taskWithBacklogData;

    /**
     * 每个查询对应的项目数据
     */
    private ProjectData projectData;
    /**
     * 作用于数据源
     */
    private List<String> dataSourceNames;
    /**
     * 执行时机点，为空表示每个action执行完毕后
     * executeCompleted-表示所有action执行完毕后
     */
    private String activePoint;

    /**
     * 用于返回的数据和任务的参数之间的映射，在批量查询数据时，可以让返回的数据附加对应的任务
     */
    private BusinessKeyMappingDTO mappingKeys;

    private List<TaskWithBacklogData> taskWithBacklogDataList;

    /**
     * 异动数据bk
     */
    private List<DataUniformityDTO> abnormalBkList;

    /**
     * 用于标记taskWithBacklogDataList有数据
    */
    private Boolean hasTaskData;
}
