package com.digiwin.athena.atdm.mongodb;

import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import java.util.List;
import java.util.Map;

public interface CommonMongodbService {

    /**
     * 创建集合（加锁）
     * @Author：SYQ
     */
    void createCollectionLock(MongoTemplate mongoTemplate, String collectionName, Map<String,Object> indexMap);

    /**
     * 插入数据
     * @Author：SYQ
     */
    void insert(MongoTemplate mongoTemplate, Map data,String collectionName);

    /**
     * 更新
     * @Author：SYQ
     */
    void updateFirst(MongoTemplate mongoTemplate, String collectionName, Query query, Update update);

    /**
     * 执行查询
     * @param collectionName
     * @param query
     * @return
     */
    List<Map> query(MongoTemplate mongoTemplate, String collectionName, Query query);


}
