package com.digiwin.athena.atdm.smartdata;


import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.smartdata.dto.RetractCompareReqDTO;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 和sd相关的交互服务
 */
public interface CommonSmartDataService {
    /**
     * 执行一个action
     *
     * @param tenantId
     * @param action
     * @return
     */
    HashMap<String, Object> execute(String tenantId, Action action);

    /**
     * 执行action，并指定一个参数
     *
     * @param tenantId
     * @param actionId
     * @param paras
     * @param eoc
     * @param extendedFields
     * @return
     */
    HashMap<String, Object> execute(String tenantId, String actionId, Map<String, Object> paras, Map eoc, Map extendedFields);

    /**
     * 执行action，并指定多个参数
     *
     * @param tenantId
     * @param actionId
     * @param paras
     * @param eoc
     * @param extendedFields 扩展字段，非必须
     * @return
     */
    Object executeWithParas(String tenantId, String actionId, Map[] paras, Map eoc, Map extendedFields);

    Object executeForManualProject(String tenantId, String actionId, Map[] paras, Map eoc, Map extendedFields);

    /**
     * 清除数据足迹数据
     *
     * @param user
     * @param instanceId   任务实例id
     * @param activityCode 模板id
     * @param entityName
     * @param eocMap
     * @param bkList
     * @return
     */
    Object clearFootprintData(AuthoredUser user, String instanceId, String activityCode, String entityName, Map<String, Object> eocMap, List<Map> bkList);

    /**
     * 清除数据一致性数据
     *
     * @param user
     * @param instanceId   任务实例id
     * @param activityCode 模板id
     * @param entityName
     * @param eocMap
     * @param bkList
     * @return
     */
    Object clearComparisonData(AuthoredUser user, String instanceId, String activityCode, String entityName, Map<String, Object> eocMap, List<Map> bkList);

    /**
     * 撤回数据一致性数据
     *
     * @param retractCompareReqDTO
     */
    void retractComparisonData(RetractCompareReqDTO retractCompareReqDTO);

    /**
     * 恢复数据
     *
     * @Author：SYQ
     * @Date：2022/5/24 10:03
     */
    Object recoverComparisonData(Map<String, Object> paramMap);

    /**
     * 放弃数据
     *
     * @Author：SYQ
     * @Date：2022/5/24 10:51
     */
    Object giveupComparisonData(Map<String, Object> paramMap);

    /**
     * 比对任务是否存在
     *
     * @Author：SYQ
     * @Date：2022/12/9 15:40
     */
    boolean existsComparison(Map<String, Object> paramMap);

    /**
     * 批量放弃数据
     *
     * @Author：SYQ
     * @Date：2022/12/9 16:13
     */
    Object batchGiveupComparisonData(Map<String, Object> paramMap);
}
