package com.digiwin.athena.atdm.terminateData.po;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * TerminateDataDO Description
 *
 * @author majianfu
 * @date 2022/2/17
 * @since
 */
@Data
public class TerminateDataDO {
    /**
     * 执行终止用户id
     */
    private String userId;

    /**
     * 执行终止用户名称
     */
    private String userName;

    /**
     * 租户Id
     */
    private String tenantId;

    /**
     * 活动ID，如待办项ID
     */
    private String activityId;

    /**
     * 活动编码
     */
    private String activityCode;

    /**
     * 活动名称，不支持多语言别，执行终止时是啥名字，这边记录的就是啥名称
     */
    private String activityName;

    /**
     * 发起终止的活动ID，如待办项ID
     */
    private String initiateActivityId;

    /**
     * 发起终止的活动编码
     */
    private String initiateActivityCode;

    /**
     * 发起终止的活动名称，不支持多语言别，执行终止时是啥名字，这边记录的就是啥名称
     */
    private String initiateActivityName;

    /**
     * BK列表
     */
    private List<Map> bkList;

    /**
     * 终止的数据集
     */
    private List<Map<String, Object>> pageData;

    /**
     * 终止的数据行数
     */
    private Integer pageDataSize;

    /**
     * 终止日期
     */
    private LocalDateTime terminateTime;

    /**
     * 操作原因（终止原因）
     */
    private String comment;
}
