package com.digiwin.athena.atdm.workflow;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.util.Map;
import java.util.Objects;

@Service
@Slf4j
public class CommonWorkflowServiceImpl implements CommonWorkflowService {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private RemoteProperties envProperties;

    @Override
    public Map<String,Object> execute(Action action) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        ActionServiceId serviceId = action.getServiceId();
        if (serviceId == null) {
            log.warn("ServiceId null, actionId: {}", action.getActionId());
            return Maps.newHashMap();
        }
        if (StringUtils.hasText(serviceId.getProxyToken())) {
            headerMap.add(GlobalConstant.IAM_USER_TOKEN, serviceId.getProxyToken());
            headerMap.add(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, serviceId.getProxyToken());
        }
        String serviceUri = envProperties.getWorkflowUri() + serviceId.getServiceUri();
        LogDto logDto = new LogDto("执行流程引擎action开始，serviceUri：" + serviceUri, serviceId.getTenant_id() + LogConstant.TRACE_SEPARATOR + serviceUri+",类型:"+serviceId.getName()+",提交参数:"+JsonUtils.objectToString(action.getParas()));
        log.info(logDto.toString());
        try {
            HttpEntity<Map<String,Object>> httpEntity = new HttpEntity<>(action.getParas(), headerMap);
            ResponseEntity<BaseResultDTO<Map<String,Object>>> responseEntity = restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Map<String,Object>>>() {
            });
            LogDto endLogDto = new LogDto("执行流程引擎action成功，serviceUri：" + serviceUri, serviceId.getTenant_id() + LogConstant.TRACE_SEPARATOR + serviceUri);
            log.info(endLogDto.toString());
            Map<String, Object> responseWithException = Objects.requireNonNull(responseEntity.getBody()).getResponseWithException("");
            // 不返回成功需要抛出异常
            if(!MapUtils.getBooleanValue(responseWithException,"success")){
                throw BusinessException.create(ErrorCodeEnum.NUM_500_0125.getErrCode(), MapUtils.getString(responseWithException,"message"));
            }
            return responseWithException;
        } catch (Exception ex) {
            LogDto errorLogDto = new LogDto("执行流程引擎action失败，serviceUri：" + serviceUri, serviceId.getTenant_id() + LogConstant.TRACE_SEPARATOR + serviceUri);
            log.info(errorLogDto.toString());
            log.error("调用工作流接口错误",ex);
            throw ex;
        }
    }
}
