/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.bpm;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.bpm.CommonBpmService;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonBpmServiceImpl
implements CommonBpmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonBpmServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void execute(Action action) {
        String serviceUri;
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        ActionServiceId serviceId = action.getServiceId();
        if (serviceId != null && StringUtils.hasText((String)serviceId.getProxyToken())) {
            headerMap.add("digi-middleware-auth-user", serviceId.getProxyToken());
            headerMap.add("token", serviceId.getProxyToken());
        }
        String string = serviceUri = null == serviceId ? "" : serviceId.getServiceUri();
        if (!serviceUri.startsWith(this.envProperties.getBpmUri())) {
            serviceUri = this.envProperties.getBpmUri() + (null == serviceId ? "" : serviceId.getServiceUri());
        }
        try {
            Map result;
            HttpEntity httpEntity = new HttpEntity(action.getParas(), (MultiValueMap)headerMap);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(serviceUri, (Object)httpEntity, Map.class, new Object[0]);
            if (responseEntity.getBody() != null && !"200".equals((result = (Map)responseEntity.getBody()).get("status").toString())) {
                String message = String.format(this.messageUtils.getMessage("exception.execution.bpm.api.fail"), result.get("errorMessage"), serviceUri, action.getParas());
                String errorCode = MapUtil.getStr((Map)result, (Object)"errorCode", (String)"");
                throw BusinessException.create((String)errorCode, (String)message);
            }
        }
        catch (BusinessException ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(action.getParas()), (Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(action.getParas()), (Object)ex);
            throw ex;
        }
    }
}

