/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;

@Configuration
public class DataCommonMongoTemplateConfig {
    @Value(value="${spring.data.mongodb.uri:}")
    private String uriLog;
    @Value(value="${spring.data.mongodb.database:}")
    private String databaseLog;
    @Value(value="${spring.data.mongodb-recycle.uri:}")
    private String recycleUri;
    @Value(value="${spring.data.mongodb-recycle.database:}")
    private String recycleDatabase;
    @Value(value="${spring.data.mongodb-terminateData.uri:}")
    private String terminateDataUri;
    @Value(value="${spring.data.mongodb-terminateData.database:}")
    private String terminateDatabase;
    @Value(value="${spring.data.mongodb-retrieveData.uri:}")
    private String retrieveDataUri;
    @Value(value="${spring.data.mongodb-retrieveData.database:}")
    private String retrieveDatabase;
    @Value(value="${spring.data.mongodb-dataUniformity.uri:}")
    private String dataUniformityUri;
    @Value(value="${spring.data.mongodb-dataUniformity.database:}")
    private String dataUniformityDatabase;
    @Value(value="${spring.data.mongodb-espRequestWorkItem.database:}")
    private String espRequestWorkItemDatabase;

    @ConditionalOnProperty(name={"spring.data.mongodb.enable"}, havingValue="true")
    @ConditionalOnMissingBean(name={"mongoTemplate"})
    @Bean(value={"mongoTemplate"})
    public MongoTemplate mongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriLog)).build(), null);
        MongoTemplate mongoTemplate = new MongoTemplate((MongoClient)client, this.databaseLog);
        this.setTypeMapper(mongoTemplate);
        return mongoTemplate;
    }

    private void setTypeMapper(MongoTemplate mongoTemplate) {
        MongoConverter converter = mongoTemplate.getConverter();
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter)converter).setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        }
    }

    @ConditionalOnProperty(name={"spring.data.mongodb-recycle.enable"}, havingValue="true")
    @ConditionalOnMissingBean(name={"recycleMongoTemplate"})
    @Bean(value={"recycleMongoTemplate"})
    public MongoTemplate recycleMongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.recycleUri)).build(), null);
        MongoTemplate recycleMongoTemplate = new MongoTemplate((MongoClient)client, this.recycleDatabase);
        this.setTypeMapper(recycleMongoTemplate);
        return recycleMongoTemplate;
    }

    @ConditionalOnProperty(name={"spring.data.mongodb-terminateData.enable"}, havingValue="true")
    @ConditionalOnMissingBean(name={"terminateDataMongoTemplate"})
    @Bean(value={"terminateDataMongoTemplate"})
    public MongoTemplate terminateDataMongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.terminateDataUri)).build(), null);
        MongoTemplate terminateDataMongoTemplate = new MongoTemplate((MongoClient)client, this.terminateDatabase);
        this.setTypeMapper(terminateDataMongoTemplate);
        return terminateDataMongoTemplate;
    }

    @ConditionalOnProperty(name={"spring.data.mongodb-retrieveData.enable"}, havingValue="true")
    @ConditionalOnMissingBean(name={"retrieveDataMongoTemplate"})
    @Bean(value={"retrieveDataMongoTemplate"})
    public MongoTemplate retrieveDataMongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.retrieveDataUri)).build(), null);
        MongoTemplate retrieveDataMongoTemplate = new MongoTemplate((MongoClient)client, this.retrieveDatabase);
        this.setTypeMapper(retrieveDataMongoTemplate);
        return retrieveDataMongoTemplate;
    }

    @ConditionalOnProperty(name={"spring.data.mongodb-dataUniformity.enable"}, havingValue="true")
    @ConditionalOnMissingBean(name={"dataUniformityMongoTemplate"})
    @Bean(value={"dataUniformityMongoTemplate"})
    public MongoTemplate dataUniformityMongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.dataUniformityUri)).build(), null);
        MongoTemplate dataUniformityMongoTemplate = new MongoTemplate((MongoClient)client, this.dataUniformityDatabase);
        this.setTypeMapper(dataUniformityMongoTemplate);
        return dataUniformityMongoTemplate;
    }

    @ConditionalOnProperty(name={"spring.data.mongodb-espRequestWorkItem.enable"}, havingValue="true")
    @ConditionalOnMissingBean(name={"espRequestWorkItemTemplate"})
    @Bean(value={"espRequestWorkItemTemplate"})
    public MongoTemplate espRequestWorkItemTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.dataUniformityUri)).build(), null);
        MongoTemplate espRequestWorkItemTemplate = new MongoTemplate((MongoClient)client, this.espRequestWorkItemDatabase);
        this.setTypeMapper(espRequestWorkItemTemplate);
        return espRequestWorkItemTemplate;
    }
}

