/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.util;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atdm.audc.CommonAudcService;
import com.digiwin.athena.atdm.audc.dto.UserTrackExtendDTO;
import com.jugg.agile.framework.core.util.concurrent.JaThreadPool;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TrackingUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrackingUtil.class);
    @Resource
    private CommonAudcService audcService;

    public void reportUserTrack(String workType, String code, String description) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        JaThreadPool.execute(() -> {
            List<UserTrackExtendDTO> requestParam = this.buildRequestParam(authoredUser, "function_analysis", workType, null, code, description);
            this.audcService.reportUserTrack(authoredUser, requestParam);
        });
    }

    private List<UserTrackExtendDTO> buildRequestParam(AuthoredUser authoredUser, String source, String workType, String appCode, String code, String description) {
        ArrayList<UserTrackExtendDTO> list = new ArrayList<UserTrackExtendDTO>();
        UserTrackExtendDTO extendDTO = new UserTrackExtendDTO();
        extendDTO.setSource(source);
        extendDTO.setWorkType(workType);
        extendDTO.setWorkCode(code);
        extendDTO.setUserId(authoredUser.getUserId());
        extendDTO.setTenantId(authoredUser.getTenantId());
        Long createTime = LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        extendDTO.setTimestamp(createTime);
        HashMap<String, Object> workContent = new HashMap<String, Object>();
        workContent.put("code", code);
        workContent.put("description", description);
        HashMap<String, Object> attachData = new HashMap<String, Object>();
        attachData.put("appCode", appCode);
        extendDTO.setWorkContent(workContent);
        extendDTO.setAttachData(attachData);
        list.add(extendDTO);
        return list;
    }
}

