package com.digiwin.athena.atdm.activity.domain;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
@NoArgsConstructor
public class AttachmentConfig {
    /**
     * 是否启用当前附件列
     */
    private Boolean enable;

    /**
     * 附件列描述
     */
    private Description description;

    private Hint hint;

    /**
     * TM Activity ID
     */
    private String taskId;

    /**
     * 是否启用附件上传
     */
    private Boolean uploadEnable;

    /**
     * 附件上传的目录
     */
    private String uploadCategory;

    /**
     * 是否可读附件
     */
    private Boolean readEnable;

    /**
     * 可读附件目录
     */
    private String[] readCategory;

    /**
     * 是否可以删除附件
     */
    private Boolean deleteEnable;

    /**
     * 可执行删除操作的附件目录
     */
    private String[] deleteCategory;

    /**
     * 上传文件限制
     */
    private FileUploadLimit fileUploadLimit;

    /**
     * 作用于某个字段，可为null
     */
    private String targetSchema;

    /**
     * 是否禁用aam：上传后的附件信息不会保存至aam
     */
    private Boolean disableAam;

    @Data
    @NoArgsConstructor
    public static class Description {
        /**
         * title，若language存在有效值，将会根据locale将title替换为language中配置的值
         */
        private String title;

        private DescLang language;
    }

    @Data
    @NoArgsConstructor
    public static class Hint {
        private String title;

        private DescLang language;
    }

    @Data
    @NoArgsConstructor
    public static class DescLang {
        /**
         * 附件列名配置：locale : "名称"
         */
        private Map<String, String> title;
    }

    @Data
    @NoArgsConstructor
    public static class FileUploadLimit {
        /**
         * 允许上传的文件扩展名列表
         */
        private String[] extensions;

        /**
         * 允许上传的文件数量
         */
        private Integer count;

        /**
         * 允许上传的文件大小
         */
        private Integer size;
    }
}
