package com.digiwin.athena.atdm.adsc;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.adsc.dto.AdscDataConditionQueryDto;
import com.digiwin.athena.atdm.adsc.dto.AdscDataQueryDTO;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ATMC 提供相关服务
 */
@Service
public class CommonAdscServiceImpl implements CommonAdscService {

    private static final Logger logger = LoggerFactory.getLogger(CommonAdscServiceImpl.class);

    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Override
    public HashMap<String, Object> query(ExecuteContext executeContext, Action action, Map<String, Object> parameter, PageInfo pageInfo, List<Map> orderInfo, List<Map> searchInfo) {
        String url = envProperties.getWebAdscUri() + "/api/appdata/page";
        AdscDataQueryDTO reqBody = new AdscDataQueryDTO();
        reqBody.setExecuteContext(executeContext);
        reqBody.setAction(action);
        reqBody.setParameter(parameter);
        reqBody.setPageInfo(pageInfo);
        reqBody.setSortInfo(orderInfo);
        reqBody.setSearchInfo(searchInfo);
        reqBody.setDataStateCode(executeContext.getDataStateCode());
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity<>(reqBody, headers);
        try {
            ResponseEntity<BaseResultDTO<HashMap<String, Object>>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<HashMap<String, Object>>>() {
                    });
            if (respEntity.getBody().isOK()) {
                return respEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            logger.error("{}, body: {}, 查询adsc数据分页服务异常：", ErrorCodeEnum.ADSC_QUERY.getErrCode(), JsonUtils.objectToString(reqBody), e);
            throw BusinessException.create(ErrorCodeEnum.ADSC_QUERY.getErrCode(), "查询adsc数据分页服务异常:" + e.getMessage());
        }
        return new HashMap<>();
    }

    @Override
    public Map<String, List<Map>> queryConditions(ExecuteContext executeContext, List<String> conditionFileds, List<Map> searchInfos) {
        String url = envProperties.getWebAdscUri() + "/api/appdata/page/queryConditions";
        AdscDataConditionQueryDto adscDataQueryDto = new AdscDataConditionQueryDto(executeContext, conditionFileds, searchInfos);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity<>(adscDataQueryDto, headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, List<Map>>>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, List<Map>>>>() {
                    });
            if (respEntity.getBody().isOK()) {
                return respEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            logger.error("{}, body: {}, 查询adsc字段统计服务异常：", ErrorCodeEnum.ADSC_QUERY_CONDITIONS.getErrCode(), JsonUtils.objectToString(adscDataQueryDto), e);
            throw BusinessException.create(ErrorCodeEnum.ADSC_QUERY_CONDITIONS.getErrCode(), "查询adsc字段统计服务异常:" + e.getMessage());
        }
        return new HashMap<>();
    }


}
